package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Objects;
import java.util.concurrent.TimeUnit;


/**
 * @Description:定时更新分子公司方案明细状态
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class SubComActivityPlanItemXxlJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SubComActivityPlanItemRepository subComActivityPlanItemRepository;

    @DynamicTaskService(cornExpression = "0 0 0 * * ?", taskDesc = "定时更新分子公司方案明细状态")
    public void autoUpdateActivityStatusXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            //尝试枷锁5秒，2小时自动释放锁
            lockSuccess = redisLockService.tryLock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_AUTO_UPDATE_STATUS, TimeUnit.HOURS, 5);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            //尝试枷锁5秒，2小时自动释放锁
            //执行业务逻辑
            this.subComActivityPlanItemRepository.autoUpdateStatus();

        } catch (Exception e) {
            log.error("定时更新分子公司方案明细状态异常");
            log.error("", e);
            throw new IllegalArgumentException(e.getMessage(), e);
        } finally {
            if (lockSuccess) {
                redisLockService.unlock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_AUTO_UPDATE_STATUS);
            }
        }
    }

}
