/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/subActivityPlan/subActivityPlan"})
@Api(tags={"\u5206\u5b50\u6d3b\u52a8\u65b9\u6848"})
public class SubComActivityPlanController {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanController.class);
    @Autowired(required=false)
    private SubComActivityPlanService subComActivityPlanService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SubComActivityPlanVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, SubComActivityPlanDto dto) {
        try {
            Page result = this.subComActivityPlanService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7f16\u8f91")
    @PostMapping(value={"create"})
    public Result create(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u5206\u5b50\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody SubComActivityPlanDto dto) {
        try {
            this.subComActivityPlanService.create(dto, cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.subComActivityPlanService.delete(ids);
            return Result.ok((String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u65b9\u6848\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody SubComActivityPlanApproveSubmitDto dto) {
        Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        List idList = dto.getIds();
        Assert.notEmpty((Collection)idList, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.batchLock("sub_com_activity_plan:lock:approve:", idList, TimeUnit.MINUTES, 10);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.subComActivityPlanService.submitApproval(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("sub_com_activity_plan:lock:approve:", idList);
            }
        }
    }

    @ApiOperation(value="\u66f4\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u8be6\u60c5")
    @GetMapping(value={"/findByProcessNo"})
    public Result<List<SubComActivityPlanVo>> findByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            List list = this.subComActivityPlanService.findByProcessNo(processNo);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7ids\u67e5\u8be6\u60c5\uff08\u4e0d\u5305\u62ec\u9884\u7b97\uff09")
    @PostMapping(value={"/findByIds"})
    public Result<List<SubComActivityPlanVo>> findByIds(@RequestBody List<String> ids) {
        try {
            List list = this.subComActivityPlanService.findByIds(ids);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be6\u60c5")
    @PostMapping(value={"/findById"})
    public Result<SubComActivityPlanVo> findByIds(@RequestParam(value="id") String id) {
        try {
            SubComActivityPlanVo vo = this.subComActivityPlanService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u4fe1\u606f")
    @GetMapping(value={"/findSubBudgetForecastByConditions"})
    public Result<Page<SubComActivityPlanBudgetVo>> findSubBudgetForecastByConditions(@PageableDefault(value=50) Pageable pageable, SubComActivityPlanBudgetDto dto) {
        try {
            Page result = this.subComActivityPlanService.findSubBudgetForecastByConditions(pageable, dto, null);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

