/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/subActivityPlanItem/subActivityPlanItem"})
@Api(tags={"\u5206\u5b50\u6d3b\u52a8\u65b9\u6848-\u65b9\u6848\u5185\u5bb9"})
public class SubComActivityPlanItemController
extends MnPageCacheController<SubComActivityPlanItemVo, SubComActivityPlanItemDto> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanItemController.class);
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u67e5\u8be2\u9009\u6846")
    @GetMapping(value={"/findPlanItemByConditions"})
    public Result<Page<SubComActivityPlanItemVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, SubComActivityPlanItemDto dto) {
        try {
            Page result = this.subComActivityPlanItemService.findPlanItemByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5ba1\u6279-\u5206\u9875-\u66f4\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u8be6\u60c5")
    @GetMapping(value={"/findByProcessNoConditions/create"})
    public Result<Page<SubComActivityPlanItemVo>> findByProcessNoConditionsCreate(@PageableDefault(value=50) Pageable pageable, SubComActivityPlanItemDto dto) {
        try {
            Page result = this.subComActivityPlanItemService.findByProcessNoConditionsCreate(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u5173\u95ed\u7684\u65b9\u6848\u5185\u5bb9")
    @GetMapping(value={"/closeFindDetail"})
    public Result<Page<SubComActivityPlanItemVo>> closeFindDetail(@PageableDefault(value=50) Pageable pageable, SubComActivityPlanItemDto dto) {
        try {
            Page page = this.subComActivityPlanItemService.closeFindItem(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result closeSubmitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody SubComActivityPlanApproveSubmitDto dto) {
        Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        List idList = dto.getIds();
        Assert.notEmpty((Collection)idList, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.batchLock("sub_com_activity_plan_close:lock:approve:", idList, TimeUnit.MINUTES, 10);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.subComActivityPlanItemService.closeSubmitApproval(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("sub_com_activity_plan_close:lock:approve:", idList);
            }
        }
    }

    @ApiOperation(value="\u66f4\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u8be2\u65b9\u6848\u5185\u5bb9\u8be6\u60c5")
    @GetMapping(value={"/findByItemProcessNo"})
    public Result<Page<SubComActivityPlanItemVo>> findByItemProcessNo(@PageableDefault(value=50) Pageable pageable, String itemProcessNo) {
        try {
            Page page = this.subComActivityPlanItemService.findByItemProcessNo(pageable, itemProcessNo);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4f7f\u7528\u660e\u7ec6")
    @GetMapping(value={"/findItemFeeByItemCode"})
    public Result<Page<SubComActivityPlanItemFeeVo>> findItemFeeByItemCode(@PageableDefault(value=50) Pageable pageable, String itemCode) {
        try {
            Page page = this.subComActivityPlanItemService.findItemFeeByItemCode(pageable, itemCode);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

