/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo.SubComActivityPlanItemExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityPlanExportItemProcess
implements ExportProcess<SubComActivityPlanItemExportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanExportItemProcess.class);
    @Autowired(required=false)
    private SubComActivityPlanItemRepository subComActivityPlanItemRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private static final String TPM_FEE_SOURCE = "tpm_fee_source";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params, (String)"\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        String subActivityPlanCode = (String)params.get("subActivityPlanCode");
        String subActivityPlanName = (String)params.get("subActivityPlanName");
        String orgCode = (String)params.get("orgCode");
        String orgName = (String)params.get("orgName");
        String processStatus = (String)params.get("processStatus");
        String subActivityPlanType = (String)params.get("subActivityPlanType");
        String feeYearMonth = (String)params.get("feeYearMonth");
        SubComActivityPlanDto selectDto = new SubComActivityPlanDto();
        selectDto.setSubActivityPlanCode(subActivityPlanCode);
        selectDto.setSubActivityPlanName(subActivityPlanName);
        selectDto.setOrgCode(orgCode);
        selectDto.setOrgName(orgName);
        selectDto.setProcessStatus(processStatus);
        selectDto.setSubActivityPlanType(subActivityPlanType);
        selectDto.setFeeYearMonth(feeYearMonth);
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        return this.subComActivityPlanItemRepository.findExportTotal(selectDto);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String subActivityPlanCode = (String)params.get("subActivityPlanCode");
        String subActivityPlanName = (String)params.get("subActivityPlanName");
        String orgCode = (String)params.get("orgCode");
        String orgName = (String)params.get("orgName");
        String processStatus = (String)params.get("processStatus");
        String subActivityPlanType = (String)params.get("subActivityPlanType");
        String feeYearMonth = (String)params.get("feeYearMonth");
        SubComActivityPlanDto selectDto = new SubComActivityPlanDto();
        selectDto.setSubActivityPlanCode(subActivityPlanCode);
        selectDto.setSubActivityPlanName(subActivityPlanName);
        selectDto.setOrgCode(orgCode);
        selectDto.setOrgName(orgName);
        selectDto.setProcessStatus(processStatus);
        selectDto.setSubActivityPlanType(subActivityPlanType);
        selectDto.setFeeYearMonth(feeYearMonth);
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page<SubComActivityPlanItemExportVo> page = this.subComActivityPlanItemRepository.findExportPage((Pageable)pageable, selectDto);
        if (page.getTotal() == 0L) {
            return new JSONArray();
        }
        page.getRecords().forEach(exVo -> {
            if (!Objects.isNull(exVo.getActivityBeginTime())) {
                exVo.setActivityBeginTimeStr(DateUtil.format((Date)exVo.getActivityBeginTime(), (String)"yyyy-MM-dd"));
            }
            if (!Objects.isNull(exVo.getActivityEndTime())) {
                exVo.setActivityEndTimeStr(DateUtil.format((Date)exVo.getActivityEndTime(), (String)"yyyy-MM-dd"));
            }
            exVo.setAuditCondition(AuditConditionEnum.findByDes((String)exVo.getAuditCondition()));
            Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{TPM_FEE_SOURCE}));
            exVo.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, exVo.getFeeSourceCode()));
        });
        return JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()));
    }

    public String getBusinessCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_ITEM_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u516c\u53f8\u65b9\u6848\u660e\u7ec6\u5bfc\u51fa";
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

