/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model.SubComActivityPlanImportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityPlanImportProcess
implements ImportProcess<SubComActivityPlanImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanImportProcess.class);
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SubComActivityPlanService subComActivityPlanService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static final String TPM_FEE_SOURCE = "tpm_fee_source";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityPlanImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            if (CollectionUtil.isEmpty(data)) {
                return null;
            }
            Collection<SubComActivityPlanImportVo> subComActivityPlanImportVos = data.values();
            subComActivityPlanImportVos.forEach(importVo -> {
                Validate.notBlank((CharSequence)importVo.getSubActivityPlanName(), (String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (!StringUtils.isBlank((CharSequence)importVo.getFeeYearMonth())) {
                    try {
                        DateUtil.parse((String)importVo.getFeeYearMonth(), (String)"yyyy-MM");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)importVo.getActivityBeginTimeStr())) {
                    if (DateTimeValidateUtil.validateDate((String)importVo.getActivityBeginTimeStr()).booleanValue()) {
                        importVo.setActivityBeginTime(DateUtil.parse((String)importVo.getActivityBeginTimeStr(), (String)"yyyy-MM-dd"));
                    } else {
                        throw new IllegalArgumentException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)importVo.getActivityEndTimeStr())) {
                    if (DateTimeValidateUtil.validateDate((String)importVo.getActivityEndTimeStr()).booleanValue()) {
                        importVo.setActivityEndTime(DateUtil.parse((String)importVo.getActivityEndTimeStr(), (String)"yyyy-MM-dd"));
                    } else {
                        throw new IllegalArgumentException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd");
                    }
                }
            });
            Map<String, List<SubComActivityPlanImportVo>> subComGroup = subComActivityPlanImportVos.stream().collect(Collectors.groupingBy(SubComActivityPlanImportVo::getSubActivityPlanName));
            subComGroup.forEach((k, v) -> {
                List orgCodes = v.stream().map(SubComActivityPlanImportVo::getOrgCode).distinct().collect(Collectors.toList());
                Validate.notEmpty(orgCodes, (String)"\u5206\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.isTrue((orgCodes.size() == 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u65b9\u6848\uff0c\u5206\u5b50\u516c\u53f8\u5fc5\u987b\u76f8\u540c\uff01", (Object[])new Object[0]);
                SubComActivityPlanDto planDto = new SubComActivityPlanDto();
                SubComActivityPlanImportVo importVo1 = (SubComActivityPlanImportVo)((Object)((Object)v.get(0)));
                String orgCode = ((SubComActivityPlanImportVo)((Object)((Object)v.get(0)))).getOrgCode();
                OrgVo orgVo = this.orgVoService.findByOrgCode(orgCode);
                Validate.notNull((Object)orgVo, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object[])new Object[0]);
                planDto.setOrgCode(orgVo.getOrgCode());
                planDto.setOrgName(orgVo.getOrgName());
                planDto.setSubActivityPlanName(importVo1.getSubActivityPlanName());
                planDto.setFeeYearMonth(importVo1.getFeeYearMonth());
                List productCodes = v.stream().map(SubComActivityPlanImportVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List productVoList = this.productVoService.findByCodes(productCodes);
                Map<Object, Object> productVoMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)productVoList)) {
                    productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                }
                List orgVos = this.orgVoService.findAllChildrenByOrgCode(orgVo.getOrgCode());
                Map<Object, Object> orgVosMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)orgVos)) {
                    orgVosMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
                }
                List activityFormCodes = v.stream().map(SubComActivityPlanImportVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List activityFormVos = this.activityFormService.findByCodes(activityFormCodes);
                HashMap<String, ActivityFormVo> activityFormMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)activityFormVos)) {
                    activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
                }
                ArrayList<SubComActivityPlanItemDto> planItemDtoList = new ArrayList<SubComActivityPlanItemDto>(v.size());
                for (SubComActivityPlanImportVo importVo : v) {
                    SubComActivityPlanItemDto planItemDto = this.conversion(importVo, productVoMap, orgVosMap, activityFormMap);
                    planItemDtoList.add(planItemDto);
                }
                planDto.setItemList(planItemDtoList);
                this.subComActivityPlanService.create(planDto, null);
            });
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5206\u5b50\u516c\u53f8\u65b9\u6848\u4e3b\u8868\u5f02\u5e38,{}", (Throwable)e);
            if (StrUtil.isEmpty((CharSequence)e.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return null;
    }

    private SubComActivityPlanItemDto conversion(SubComActivityPlanImportVo importVo, Map<String, ProductVo> productVoMap, Map<String, OrgVo> orgVosMap, Map<String, ActivityFormVo> activityFormMap) {
        SubComActivityPlanItemDto planItem = (SubComActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notBlank((CharSequence)importVo.getTotalCostStr(), (String)("\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + planItem.getSubActivityPlanItemName() + "]\u7684 '\u8d39\u7528\u91d1\u989d',\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importVo.getExpectSalesAmountStr(), (String)("\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + planItem.getSubActivityPlanItemName() + "]\u7684 '\u9884\u9500\u552e\u989d',\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        try {
            planItem.setTotalCost(new BigDecimal(importVo.getTotalCostStr()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + planItem.getSubActivityPlanItemName() + "]\u7684 \u2019\u8d39\u7528\u91d1\u989d\u2018\u586b\u5199\u6709\u8bef\uff01");
        }
        try {
            planItem.setExpectSalesAmount(new BigDecimal(importVo.getExpectSalesAmountStr()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + planItem.getSubActivityPlanItemName() + "]\u7684 \u2019\u9884\u9500\u552e\u989d\u2018\u586b\u5199\u6709\u8bef\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)planItem.getOrgCode())) {
            if (!CollectionUtils.isEmpty(orgVosMap)) {
                OrgVo orgVo = orgVosMap.get(importVo.getItemOrgCode());
                Validate.notNull((Object)orgVo, (String)("\u672a\u67e5\u8be2\u5230\u5206\u5b50\u516c\u53f8[" + importVo.getOrgName() + importVo.getOrgCode() + "]\u7684\u4e0b\u7ea7\u6267\u884c\u90e8\u95e8[" + importVo.getItemOrgName() + importVo.getItemOrgCode() + "]!"), (Object[])new Object[0]);
                planItem.setOrgCode(orgVo.getOrgCode());
                planItem.setOrgName(orgVo.getOrgName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u6267\u884c\u90e8\u95e8\u4fe1\u606f\uff01" + planItem.getOrgCode());
            }
        }
        if (!StringUtils.isBlank((CharSequence)planItem.getProductCode())) {
            if (!CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(planItem.getProductCode());
                Validate.notNull((Object)productVo, (String)("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f\uff01" + planItem.getProductCode()), (Object[])new Object[0]);
                planItem.setProductCode(productVo.getProductCode());
                planItem.setProductName(productVo.getProductName());
                planItem.setProductBrandCode(productVo.getProductBrandCode());
                planItem.setProductBrandName(productVo.getProductBrandName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f\uff01" + planItem.getProductCode());
            }
        }
        if (!StringUtils.isBlank((CharSequence)planItem.getActivityFormCode())) {
            if (!CollectionUtils.isEmpty(activityFormMap)) {
                ActivityFormVo activityFormVo = activityFormMap.get(planItem.getActivityFormCode());
                Validate.notNull((Object)activityFormVo, (String)("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f\uff01" + planItem.getActivityFormCode()), (Object[])new Object[0]);
                planItem.setActivityFormCode(activityFormVo.getActivityFormCode());
                planItem.setActivityFormName(activityFormVo.getActivityFormName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f\uff01" + planItem.getActivityFormCode());
            }
        }
        planItem.setAuditCondition(AuditConditionEnum.findByDes((String)importVo.getAuditCondition()));
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{TPM_FEE_SOURCE}));
        planItem.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, planItem.getFeeSourceCode()));
        return planItem;
    }

    public Class<SubComActivityPlanImportVo> findCrmExcelVoClass() {
        return SubComActivityPlanImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u516c\u53f8\u65b9\u6848\u5bfc\u5165";
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse("");
    }
}

