/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.service;

import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model.SubComActivityPlanItemImportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal.SubComActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityPlanItemImportProcess
implements ImportProcess<SubComActivityPlanItemImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanItemImportProcess.class);
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityPlanItemPageCacheHelper subComActivityPlanItemPageCacheHelper;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private static final String TPM_FEE_SOURCE = "tpm_fee_source";

    public Integer getBatchCount() {
        return 2000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityPlanItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            log.info("TPM-\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u5bfc\u5165-\u4e70\u8d60\uff0c\u6267\u884c");
            Object cacheKey = params.get("cacheKey");
            Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
            Collection<SubComActivityPlanItemImportVo> values = data.values();
            if (CollectionUtils.isNotEmpty(values)) {
                List productCodes = values.stream().map(SubComActivityPlanItemImportVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List productVoList = this.productVoService.findByCodes(productCodes);
                Map<Object, Object> productVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)productVoList)) {
                    productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                }
                List itemOrgVoCodes = values.stream().map(SubComActivityPlanItemImportVo::getOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List orgVos = this.orgVoService.findByOrgCodes(itemOrgVoCodes);
                Map<Object, Object> orgVosMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)orgVos)) {
                    orgVosMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity(), (v1, v2) -> v2));
                }
                List activityFormCodes = values.stream().map(SubComActivityPlanItemImportVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List activityFormVos = this.activityFormService.findByCodes(activityFormCodes);
                HashMap<String, ActivityFormVo> activityFormMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)activityFormVos)) {
                    activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
                }
                ArrayList<SubComActivityPlanItemDto> itemDtoList = new ArrayList<SubComActivityPlanItemDto>(values.size());
                for (SubComActivityPlanItemImportVo importVo : values) {
                    SubComActivityPlanItemDto itemDto = this.conversion(importVo, productVoMap, orgVosMap, activityFormMap);
                    if (Objects.isNull(itemDto)) continue;
                    itemDtoList.add(itemDto);
                }
                this.subComActivityPlanItemPageCacheHelper.importNewItem(cacheKey.toString(), itemDtoList);
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5206\u5b50\u516c\u53f8\u65b9\u6848\u660e\u7ec6\u5f02\u5e38,{}", (Throwable)e);
            if (StrUtil.isEmpty((CharSequence)e.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return null;
    }

    private SubComActivityPlanItemDto conversion(SubComActivityPlanItemImportVo importVo, Map<String, ProductVo> productVoMap, Map<String, OrgVo> orgVosMap, Map<String, ActivityFormVo> activityFormMap) {
        if (Objects.isNull((Object)importVo)) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)importVo.getActivityBeginTimeStr())) {
            if (DateTimeValidateUtil.validateDate((String)importVo.getActivityBeginTimeStr()).booleanValue()) {
                importVo.setActivityBeginTime(DateUtil.parse((String)importVo.getActivityBeginTimeStr(), (String)"yyyy-MM-dd"));
            } else {
                throw new IllegalArgumentException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd");
            }
        }
        if (!StringUtils.isBlank((CharSequence)importVo.getActivityEndTimeStr())) {
            if (DateTimeValidateUtil.validateDate((String)importVo.getActivityEndTimeStr()).booleanValue()) {
                importVo.setActivityEndTime(DateUtil.parse((String)importVo.getActivityEndTimeStr(), (String)"yyyy-MM-dd"));
            } else {
                throw new IllegalArgumentException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd");
            }
        }
        SubComActivityPlanItemDto itemDto = (SubComActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        try {
            itemDto.setTotalCost(StringUtils.isBlank((CharSequence)importVo.getTotalCostStr()) ? BigDecimal.ZERO : new BigDecimal(importVo.getTotalCostStr()));
            itemDto.setExpectSalesAmount(StringUtils.isBlank((CharSequence)importVo.getExpectSalesAmountStr()) ? BigDecimal.ZERO : new BigDecimal(importVo.getExpectSalesAmountStr()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + itemDto.getSubActivityPlanItemName() + "]\u7684 \u2019\u8d39\u7528\u91d1\u989d\u2018\u6216\u2019\u9884\u9500\u552e\u989d\u2018\u586b\u5199\u6709\u8bef\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)itemDto.getOrgCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(orgVosMap)) {
                OrgVo orgVo = orgVosMap.get(importVo.getOrgCode());
                Validate.notNull((Object)orgVo, (String)("\u672a\u67e5\u8be2\u5230\u65b9\u6848\u660e\u7ec6\u540d\u79f0[" + itemDto.getSubActivityPlanItemName() + "]\u7684\u6267\u884c\u90e8\u95e8[" + itemDto.getOrgName() + itemDto.getOrgCode() + "]!"), (Object[])new Object[0]);
                itemDto.setOrgCode(orgVo.getOrgCode());
                itemDto.setOrgName(orgVo.getOrgName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u6267\u884c\u90e8\u95e8\u4fe1\u606f\uff01" + itemDto.getOrgCode());
            }
        }
        if (!StringUtils.isBlank((CharSequence)itemDto.getProductCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(itemDto.getProductCode());
                Validate.notNull((Object)productVo, (String)("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f\uff01" + itemDto.getProductCode()), (Object[])new Object[0]);
                itemDto.setProductCode(productVo.getProductCode());
                itemDto.setProductName(productVo.getProductName());
                itemDto.setProductBrandCode(productVo.getProductBrandCode());
                itemDto.setProductBrandName(productVo.getProductBrandName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f\uff01" + itemDto.getProductCode());
            }
        }
        if (!StringUtils.isBlank((CharSequence)itemDto.getActivityFormCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(activityFormMap)) {
                ActivityFormVo activityFormVo = activityFormMap.get(itemDto.getActivityFormCode());
                Validate.notNull((Object)activityFormVo, (String)("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f\uff01" + itemDto.getActivityFormCode()), (Object[])new Object[0]);
                itemDto.setActivityFormCode(activityFormVo.getActivityFormCode());
                itemDto.setActivityFormName(activityFormVo.getActivityFormName());
                itemDto.setActivityTypeCode(activityFormVo.getActivityTypeCode());
                itemDto.setActivityTypeName(activityFormVo.getActivityTypeName());
            } else {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f\uff01" + itemDto.getActivityFormCode());
            }
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{TPM_FEE_SOURCE}));
        itemDto.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, itemDto.getFeeSourceCode()));
        itemDto.setAuditCondition(AuditConditionEnum.findByDes((String)importVo.getAuditCondition()));
        return itemDto;
    }

    public Class<SubComActivityPlanItemImportVo> findCrmExcelVoClass() {
        return SubComActivityPlanItemImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_ITEM_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u516c\u53f8\u65b9\u6848\u660e\u7ec6\u5bfc\u5165";
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse("");
    }
}

