/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.listener;

import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubActivityPlanCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(SubActivityPlanCompleteListener.class);
    @Autowired(required=false)
    private SubComActivityPlanService subComActivityPlanService;

    public String getBusinessCode() {
        return "SUB_COM_ACTIVITY_PLAN_PROCESS_CODE";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String processStatus = dto.getProcessStatus();
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.subComActivityPlanService.passProcessBusiness(dto.getProcessNo(), processStatus);
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.subComActivityPlanService.failProcessBusiness(dto.getProcessNo(), processStatus);
        }
    }
}

