/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo.SubComActivityPlanItemExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanItemMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityPlanItemRepository
extends ServiceImpl<SubComActivityPlanItemMapper, SubComActivityPlanItem> {
    public List<SubComActivityPlanItem> findBySubPlanCode(String subActivityPlanCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityPlanItem::getSubActivityPlanCode, (Object)subActivityPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<SubComActivityPlanItem> findBySubPlanCodes(List<String> subPlanCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityPlanItem::getSubActivityPlanCode, subPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    public Page<SubComActivityPlanItemVo> closeFindItem(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return ((SubComActivityPlanItemMapper)this.baseMapper).closeFindItem(page, dto);
    }

    public Page<SubComActivityPlanItemVo> findByItemProcessNo(Page<SubComActivityPlanVo> page, String itemProcessNo) {
        return ((SubComActivityPlanItemMapper)this.baseMapper).findByItemProcessNo(page, itemProcessNo, TenantUtils.getTenantCode());
    }

    public Integer findExportTotal(SubComActivityPlanDto dto) {
        if (Objects.isNull(dto)) {
            return 0;
        }
        return ((SubComActivityPlanItemMapper)this.baseMapper).findExportTotal(dto);
    }

    public Page<SubComActivityPlanItemExportVo> findExportPage(Pageable pageable, SubComActivityPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((SubComActivityPlanItemMapper)this.baseMapper).findExportPage((Page<SubComActivityPlanVo>)page, dto);
    }

    public List<SubComActivityPlanItem> findByItemCodes(List<String> itemCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityPlanItem::getSubActivityPlanItemCode, itemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateActivityStatusByPlanCodes(List<String> planCodes, String status) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComActivityPlanItem::getActivityStatus, (Object)status)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SubComActivityPlanItem::getSubActivityPlanCode, planCodes)).update();
    }

    public void updateActivityStatusByProcessNo(String processNo, String status) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComActivityPlanItem::getActivityStatus, (Object)status)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SubComActivityPlanItem::getItemProcessNo, (Object)processNo)).update();
    }

    public void autoUpdateStatus() {
        ((SubComActivityPlanItemMapper)this.baseMapper).autoUpdateStatus(ProcessStatusEnum.PASS.getDictCode(), SubPlanStatusEnum.END.getCode(), TenantUtils.getTenantCode());
    }

    public Page<SubComActivityPlanItemVo> findPlanItemByConditions(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return ((SubComActivityPlanItemMapper)this.baseMapper).findPlanItemByConditions(page, dto);
    }

    public void updateReturnAmount(List<SubComActivityPlanItemDto> updateSubPlanItemList) {
        ((SubComActivityPlanItemMapper)this.baseMapper).updateReturnAmount(updateSubPlanItemList, TenantUtils.getTenantCode());
    }

    public Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return ((SubComActivityPlanItemMapper)this.baseMapper).findByProcessNoConditionsCreate(page, dto);
    }
}

