/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlan;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityPlanRepository
extends ServiceImpl<SubComActivityPlanMapper, SubComActivityPlan> {
    public Page<SubComActivityPlanVo> findByConditions(Page<SubComActivityPlanVo> page, SubComActivityPlanDto dto) {
        return ((SubComActivityPlanMapper)this.baseMapper).findByConditions(page, dto);
    }

    public List<SubComActivityPlan> listByIds(List<String> ids, String delFlag) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateProcessStatusAndProcessNo(List<String> ids, String processStatus, String processNo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComActivityPlan::getProcessStatus, (Object)processStatus)).set(SubComActivityPlan::getProcessNo, (Object)processNo)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).update();
    }

    public void updateProcessStatusByProcessNo(String processNo, String processStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComActivityPlan::getProcessStatus, (Object)processStatus)).eq(SubComActivityPlan::getProcessNo, (Object)processNo)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public List<SubComActivityPlanVo> findByProcessNo(String processNo) {
        return ((SubComActivityPlanMapper)this.baseMapper).findByProcessNo(processNo, TenantUtils.getTenantCode());
    }

    public List<String> findPlanCodeByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return ((SubComActivityPlanMapper)this.baseMapper).findPlanCodeByProcessNo(processNo, TenantUtils.getTenantCode());
    }
}

