/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityPlanBudgetServiceImpl
implements SubComActivityPlanBudgetService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanBudgetServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityPlanBudgetRepository subComActivityPlanBudgetRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteBySubPlanCodes(List<String> versionCode) {
        if (CollectionUtils.isEmpty(versionCode)) {
            return;
        }
        this.subComActivityPlanBudgetRepository.deleteBySubPlanCodes(versionCode);
    }

    public List<SubComActivityPlanBudgetVo> findBySubPlanCode(String versionCode) {
        if (StringUtils.isBlank((CharSequence)versionCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanBudget> list = this.subComActivityPlanBudgetRepository.findBySubPlanCode(versionCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityPlanBudget.class, SubComActivityPlanBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void saveBudget(String subActivityPlanCode, List<SubComActivityPlanBudgetDto> budgetList) {
        if (CollectionUtils.isEmpty(budgetList) || StringUtils.isBlank((CharSequence)subActivityPlanCode)) {
            return;
        }
        this.subComActivityPlanBudgetRepository.remove((Wrapper)Wrappers.lambdaUpdate(SubComActivityPlanBudget.class).eq(SubComActivityPlanBudget::getSubActivityPlanCode, (Object)subActivityPlanCode));
        Collection planBudgets = this.nebulaToolkitService.copyCollectionByWhiteList(budgetList, SubComActivityPlanBudgetDto.class, SubComActivityPlanBudget.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityPlanBudgetRepository.saveBatch(planBudgets);
    }

    public Page<SubComActivityPlanBudgetVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityPlanBudgetDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto) || com.alibaba.excel.util.StringUtils.isBlank((CharSequence)dto.getProcessNo())) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityPlanBudgetRepository.findByProcessNoConditionsCreate((Page<SubComActivityPlanVo>)page, dto);
    }
}

