/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItemFee;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemFeeRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityPlanItemFeeServiceImpl
implements SubComActivityPlanItemFeeService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanItemFeeServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityPlanItemFeeRepository subComActivityPlanItemFeeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeList)) {
            return;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(subPlanItemFeeList, SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityPlanItemFeeRepository.saveBatch(list);
    }

    public void saveItemFee(String subActivityPlanCode, List<SubComActivityPlanItemDto> itemCacheList) {
        if (StringUtils.isBlank((CharSequence)subActivityPlanCode) || CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        this.subComActivityPlanItemFeeRepository.remove((Wrapper)Wrappers.lambdaUpdate(SubComActivityPlanItemFee.class).eq(SubComActivityPlanItemFee::getSubActivityPlanCode, (Object)subActivityPlanCode));
        ArrayList list = new ArrayList();
        for (SubComActivityPlanItemDto item : itemCacheList) {
            if (CollectionUtils.isEmpty((Collection)item.getItemFeeList())) continue;
            list.addAll(item.getItemFeeList());
        }
        if (!CollectionUtils.isEmpty(list)) {
            Collection entityList = this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class, new String[0]);
            this.subComActivityPlanItemFeeRepository.saveBatch(entityList);
        }
    }

    public List<SubComActivityPlanItemFeeVo> findUsedByActivityDesignCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItemFee> list = this.subComActivityPlanItemFeeRepository.findByActivityDesignCode(activityDesignCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityPlanItemFee.class, SubComActivityPlanItemFeeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public SubComActivityPlanItemFeeVo findLastByItemCode(String itemCode) {
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            return null;
        }
        return this.subComActivityPlanItemFeeRepository.findLastByItemCode(itemCode);
    }
}

