/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityPlanItemPageCacheHelper
extends MnPageCacheHelper<SubComActivityPlanItemVo, SubComActivityPlanItemDto> {
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "sub_com_activity_plan_cache:item_cache:";
    }

    public Class<SubComActivityPlanItemDto> getDtoClass() {
        return SubComActivityPlanItemDto.class;
    }

    public Class<SubComActivityPlanItemVo> getVoClass() {
        return SubComActivityPlanItemVo.class;
    }

    public List<SubComActivityPlanItemDto> findDtoListFromRepository(SubComActivityPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getSubActivityPlanCode())) {
            return Lists.newArrayList();
        }
        List itemVoList = this.subComActivityPlanItemService.findBySubPlanCode(dto.getSubActivityPlanCode());
        List itemDtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)itemVoList, SubComActivityPlanItemVo.class, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        itemDtoList.sort(Comparator.comparing(SubComActivityPlanItemDto::getSubActivityPlanItemCode));
        return itemDtoList;
    }

    public List<SubComActivityPlanItemDto> newItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        SubComActivityPlanItemDto newItem = new SubComActivityPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new SubComActivityPlanItemDto[]{newItem});
    }

    public List<SubComActivityPlanItemDto> copyItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityPlanItemDto.class, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (SubComActivityPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setSubActivityPlanItemCode(null);
        }
        return newItemList;
    }

    public Object getDtoKey(SubComActivityPlanItemDto subComActivityPlanItemDto) {
        return subComActivityPlanItemDto.getId();
    }

    public String getCheckedStatus(SubComActivityPlanItemDto subComActivityPlanItemDto) {
        return subComActivityPlanItemDto.getChecked();
    }

    public void importNewItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        for (SubComActivityPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<SubComActivityPlanItemVo> dtoListToVoList(List<SubComActivityPlanItemDto> dtoList) {
        ArrayList<SubComActivityPlanItemVo> list = new ArrayList<SubComActivityPlanItemVo>();
        if (CollectionUtils.isEmpty(dtoList)) {
            return list;
        }
        for (SubComActivityPlanItemDto itemDto : dtoList) {
            SubComActivityPlanItemVo feeVo = (SubComActivityPlanItemVo)this.nebulaToolkitService.copyObjectByBlankList((Object)itemDto, this.getVoClass(), HashSet.class, ArrayList.class, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)itemDto.getItemFeeList())) {
                List itemFeeVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemDto.getItemFeeList(), SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFeeVo.class, HashSet.class, ArrayList.class, new String[0]);
                feeVo.setItemFeeList(itemFeeVoList);
            }
            list.add(feeVo);
        }
        return list;
    }

    public void updateItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
    }
}

