/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItemFee;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemFeeRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComActivityPlanItemServiceImpl
implements SubComActivityPlanItemService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanItemServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityPlanItemRepository subComActivityPlanItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityPlanItemFeeRepository subComActivityPlanItemFeeRepository;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private SubComActivityPlanItemFeeService subComActivityPlanItemFeeService;

    @Transactional(rollbackFor={Exception.class})
    public void saveItem(boolean update, SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getSubActivityPlanCode()) || CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        List<Object> oldList = new ArrayList();
        if (update) {
            oldList = this.subComActivityPlanItemRepository.findBySubPlanCode(dto.getSubActivityPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List itemList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemCacheList, SubComActivityPlanItemDto.class, SubComActivityPlanItem.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityPlanItem item : itemList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityPlanItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityPlanItemRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityPlanItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
            ArrayList<String> itemCodes = new ArrayList<String>(oldMap.size());
            oldMap.forEach((k, v) -> itemCodes.add(v.getSubActivityPlanItemCode()));
            this.subComActivityPlanItemFeeRepository.deleteByItemCodes(itemCodes);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBySubPlanCodes(List<String> subPlanCodes) {
        if (CollectionUtils.isEmpty(subPlanCodes)) {
            return;
        }
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findBySubPlanCodes(subPlanCodes);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<String> itemCodes = itemList.stream().map(SubComActivityPlanItem::getSubActivityPlanItemCode).distinct().collect(Collectors.toList());
        List<String> ids = itemList.stream().map(UuidEntity::getId).distinct().collect(Collectors.toList());
        this.subComActivityPlanItemRepository.deleteByIds(ids);
        this.subComActivityPlanItemFeeRepository.deleteByItemCodes(itemCodes);
    }

    public List<SubComActivityPlanItemVo> findBySubPlanCodes(List<String> subPlanCodes) {
        if (CollectionUtils.isEmpty(subPlanCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findBySubPlanCodes(subPlanCodes);
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, SubComActivityPlanItem.class, SubComActivityPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComActivityPlanItemVo> findBySubPlanCode(String subPlanCode) {
        if (StringUtils.isBlank((CharSequence)subPlanCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findBySubPlanCode(subPlanCode);
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, SubComActivityPlanItem.class, SubComActivityPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<SubComActivityPlanItemVo> closeFindItem(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityPlanItemRepository.closeFindItem((Page<SubComActivityPlanVo>)page, dto);
    }

    public void closeSubmitApproval(SubComActivityPlanApproveSubmitDto dto) {
        List itemList = this.subComActivityPlanItemRepository.listByIds(dto.getIds());
        Validate.notEmpty((Collection)itemList, (String)"\u8981\u5173\u95ed\u7684\u65b9\u6848\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        itemList.forEach(item -> {
            if (!SubPlanStatusEnum.EXECUTING.getCode().equals(item.getActivityStatus()) && !SubPlanStatusEnum.CLOSE_REJECT.getCode().equals(item.getActivityStatus())) {
                throw new IllegalArgumentException("\u53ea\u6709 \u2019\u6267\u884c\u4e2d / \u5173\u95ed\u5ba1\u6279\u9a73\u56de\u2019 \u72b6\u6001\u7684\u65b9\u6848\u5185\u5bb9\u624d\u53ef\u5173\u95ed\uff01");
            }
        });
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNoList(dto.getIds());
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("SUB_COM_ACTIVITY_PLAN_CLOSE_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        itemList.forEach(detail -> {
            detail.setItemProcessNo(processBusinessVo.getProcessNo());
            detail.setActivityStatus(SubPlanStatusEnum.CLOSE_COMMIT.getCode());
        });
        this.subComActivityPlanItemRepository.updateBatchById(itemList);
    }

    public Page<SubComActivityPlanItemVo> findByItemProcessNo(Pageable pageable, String itemProcessNo) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Validate.notBlank((CharSequence)itemProcessNo, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.subComActivityPlanItemRepository.findByItemProcessNo((Page<SubComActivityPlanVo>)page, itemProcessNo);
    }

    public List<SubComActivityPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> list = this.subComActivityPlanItemRepository.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityPlanItem.class, SubComActivityPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void updateActivityStatusByProcessNo(List<String> planCodes, String status) {
        if (CollectionUtils.isEmpty(planCodes) || StringUtils.isBlank((CharSequence)status)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByPlanCodes(planCodes, status);
    }

    public Page<SubComActivityPlanItemFeeVo> findItemFeeByItemCode(Pageable pageable, String itemCode) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Validate.notBlank((CharSequence)itemCode, (String)"\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.subComActivityPlanItemFeeRepository.findItemFeeByItemCode((Page<SubComActivityPlanItemFeeVo>)page, itemCode);
    }

    public void closeFailProcessBusiness(String processNo, String status) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByProcessNo(processNo, status);
    }

    public void closePassProcessBusiness(String processNo, String status) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByProcessNo(processNo, status);
    }

    public Page<SubComActivityPlanItemVo> findPlanItemByConditions(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new SubComActivityPlanItemDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.subComActivityPlanItemRepository.findPlanItemByConditions((Page<SubComActivityPlanVo>)page, dto);
    }

    public void generateItemFeeByDesignClosed(List<SubComActivityPlanItemFeeDto> subPlanItemFeeDtoList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeDtoList)) {
            return;
        }
        Map<String, List<SubComActivityPlanItemFeeDto>> itemFeeDtoMap = subPlanItemFeeDtoList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemFeeDto::getSubActivityPlanItemCode));
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findByItemCodes(Lists.newArrayList(itemFeeDtoMap.keySet()));
        ArrayList updateItemList = new ArrayList();
        ArrayList createItemFeeList = new ArrayList();
        Map itemMap = itemList.stream().collect(Collectors.toMap(SubComActivityPlanItem::getSubActivityPlanItemCode, Function.identity()));
        itemMap.forEach((k, v) -> {
            SubComActivityPlanItemFeeVo lastItemFee = this.subComActivityPlanItemFeeRepository.findLastByItemCode((String)k);
            List itemFeeList = (List)itemFeeDtoMap.get(k);
            BigDecimal beforeAmount = Optional.ofNullable(lastItemFee.getBalanceAmount()).orElse(BigDecimal.ZERO);
            Date date = new Date();
            BigDecimal residueAmount = BigDecimal.ZERO;
            for (int i = 0; i < itemFeeList.size(); ++i) {
                SubComActivityPlanItemFeeDto feeDto = (SubComActivityPlanItemFeeDto)itemFeeList.get(i);
                SubComActivityPlanItemFee fee = (SubComActivityPlanItemFee)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)feeDto, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class, new String[0])));
                fee.setBeforeAmount(beforeAmount);
                BigDecimal curOperationAmount = Optional.ofNullable(fee.getCurOperationAmount()).orElse(BigDecimal.ZERO);
                BigDecimal balanceAmount = beforeAmount.add(curOperationAmount);
                fee.setBalanceAmount(balanceAmount);
                fee.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
                fee.setTenantCode(TenantUtils.getTenantCode());
                fee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                fee.setSubActivityPlanItemCode((String)k);
                fee.setSubActivityPlanItemName(v.getSubActivityPlanItemName());
                fee.setInitialAmount(lastItemFee.getInitialAmount());
                fee.setSortAsc(Long.parseLong(DateUtil.format((Date)date, (String)("yyyyMMddHHmmss" + i))));
                fee.setSubActivityPlanCode(v.getSubActivityPlanCode());
                fee.setSubActivityPlanItemCode(v.getSubActivityPlanItemCode());
                fee.setSubActivityPlanItemName(v.getSubActivityPlanItemName());
                fee.setInitialAmount(lastItemFee.getInitialAmount());
                fee.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                residueAmount = residueAmount.add(curOperationAmount);
                beforeAmount = balanceAmount;
                createItemFeeList.add(fee);
            }
            v.setResidueAmount(v.getResidueAmount().add(residueAmount));
            v.setUsedAmount(v.getUsedAmount().subtract(residueAmount));
            updateItemList.add(v);
        });
        if (!CollectionUtils.isEmpty(updateItemList)) {
            this.subComActivityPlanItemRepository.updateBatchById(updateItemList);
        }
        if (!CollectionUtils.isEmpty(createItemFeeList)) {
            // empty if block
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void useSubPlanItemFee(List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeList)) {
            return;
        }
        log.info("\u5206\u5b50\u65b9\u6848\u4f7f\u7528\u91d1\u989d\u8bb0\u5f551");
        List collect = subPlanItemFeeList.stream().filter(f -> !ForecastOperationTypeEnum.USE.getCode().equals(f.getOperationType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            throw new IllegalArgumentException("\u4ec5\u9650\u64cd\u4f5c\u7c7b\u578b\u4e3a\u2018\u4f7f\u7528\u2019\u3002");
        }
        log.info("\u5206\u5b50\u65b9\u6848\u4f7f\u7528\u91d1\u989d\u8bb0\u5f552");
        Map<String, List<SubComActivityPlanItemFeeDto>> subPlanItemFeeMap = subPlanItemFeeList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemFeeDto::getSubActivityPlanItemCode));
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findByItemCodes(Lists.newArrayList(subPlanItemFeeMap.keySet()));
        Map itemMap = itemList.stream().collect(Collectors.toMap(SubComActivityPlanItem::getSubActivityPlanItemCode, Function.identity()));
        ArrayList updateList = new ArrayList();
        subPlanItemFeeMap.forEach((k, v) -> {
            SubComActivityPlanItem item = (SubComActivityPlanItem)((Object)((Object)itemMap.get(k)));
            Validate.notNull((Object)((Object)item), (String)"\u5206\u5b50\u65b9\u6848\u4f7f\u7528\u91d1\u989d\u8bb0\u5f55\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u65b9\u6848\u5185\u5bb9", (Object[])new Object[0]);
            BigDecimal reduce = v.stream().map(SubComActivityPlanItemFeeDto::getCurOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal residueAmount = Optional.ofNullable(item.getResidueAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
            item.setResidueAmount(residueAmount.subtract(reduce));
            item.setUsedAmount(usedAmount.add(reduce));
            log.info("\u5206\u5b50\u65b9\u6848\u4f7f\u7528\u91d1\u989d\u8bb0\u5f553,\u65b9\u6848:{},\u5269\u4f59:{}", (Object)item.getSubActivityPlanItemCode(), (Object)item.getResidueAmount());
            log.info("\u5206\u5b50\u65b9\u6848\u4f7f\u7528\u91d1\u989d\u8bb0\u5f554,\u65b9\u6848:{},\u5df2\u7528:{}", (Object)item.getSubActivityPlanItemCode(), (Object)item.getUsedAmount());
            updateList.add(item);
        });
        this.subComActivityPlanItemRepository.updateBatchById(updateList);
        this.subComActivityPlanItemFeeService.saveBatch(subPlanItemFeeList);
    }

    public void updateReturnAmount(List<SubComActivityPlanItemDto> updateSubPlanItemList) {
        if (CollectionUtils.isEmpty(updateSubPlanItemList)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateReturnAmount(updateSubPlanItemList);
    }

    public Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getProcessNo())) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComActivityPlanItemVo> resultPage = this.subComActivityPlanItemRepository.findByProcessNoConditionsCreate((Page<SubComActivityPlanVo>)page, dto);
        if (Objects.isNull(resultPage) || org.springframework.util.CollectionUtils.isEmpty((Collection)resultPage.getRecords())) {
            return resultPage;
        }
        List detailList = resultPage.getRecords();
        detailList.forEach(detail -> {
            if (Objects.isNull(detail.getExpectSalesAmount()) || BigDecimal.ZERO.compareTo(detail.getExpectSalesAmount()) == 0) {
                detail.setCostSalesRatio(BigDecimal.ZERO);
            } else {
                BigDecimal totalCost = Optional.ofNullable(detail.getTotalCost()).orElse(BigDecimal.ZERO);
                detail.setCostSalesRatio(totalCost.divide(detail.getExpectSalesAmount(), 2, 4));
            }
        });
        return resultPage;
    }
}

