/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlan;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.SubComActivityPlanBudgetCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.SubComActivityPlanItemCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.BudgetAmountResponse;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubPlanCallSubActivityDesignEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.event.SubPlanCallSubActivityDesignEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComActivityPlanServiceImpl
implements SubComActivityPlanService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityPlanServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityPlanRepository subComActivityPlanRepository;
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private SubComActivityPlanItemCacheService subComActivityPlanItemCacheService;
    @Autowired(required=false)
    private SubComActivityPlanBudgetService subComActivityPlanBudgetService;
    @Autowired(required=false)
    private SubComActivityPlanBudgetCacheService subComActivityPlanBudgetCacheService;
    @Autowired(required=false)
    private SubComActivityPlanItemFeeService subComActivityPlanItemFeeService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<SubComActivityPlanVo> findByConditions(Pageable pageable, SubComActivityPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityPlanRepository.findByConditions((Page<SubComActivityPlanVo>)page, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(SubComActivityPlanDto dto, String cacheKey) {
        this.validateValue(dto);
        List itemCacheList = new ArrayList();
        itemCacheList = StringUtils.isNotEmpty((CharSequence)cacheKey) ? this.subComActivityPlanItemCacheService.findCacheList(cacheKey) : dto.getItemList();
        List<SubComActivityPlanBudgetDto> budgetList = this.findAndBuildBudgetDate(dto, itemCacheList);
        dto.setBudgetList(budgetList);
        this.validateItemValueAndGenerateItemFee(dto, itemCacheList);
        this.savePlanAndItem(dto, itemCacheList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePlanAndItem(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        SubComActivityPlan entity = null;
        boolean update = StringUtils.isNotBlank((CharSequence)dto.getId());
        if (update) {
            SubComActivityPlan old = (SubComActivityPlan)((Object)this.subComActivityPlanRepository.getById((Serializable)((Object)dto.getId())));
            Validate.notNull((Object)((Object)old), (String)"\u8981\u4fee\u6539\u662f\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(old.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(old.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(old.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u5206\u5b50\u6d3b\u52a8\u65b9\u6848", (Object[])new Object[0]);
            dto.setSubActivityPlanCode(old.getSubActivityPlanCode());
            dto.setTenantCode(old.getTenantCode());
            entity = (SubComActivityPlan)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityPlan.class, HashSet.class, ArrayList.class, new String[0]));
            this.subComActivityPlanRepository.updateById((Object)entity);
        } else {
            entity = (SubComActivityPlan)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityPlan.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("FZFA", 1, Integer.valueOf(6), -1L, TimeUnit.DAYS).get(0);
            entity.setSubActivityPlanCode(code);
            dto.setSubActivityPlanCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            this.subComActivityPlanRepository.save((Object)entity);
        }
        this.buildCommonCode(dto, itemCacheList);
        this.subComActivityPlanItemService.saveItem(update, dto, itemCacheList);
        this.subComActivityPlanBudgetService.saveBudget(dto.getSubActivityPlanCode(), dto.getBudgetList());
        this.subComActivityPlanItemFeeService.saveItemFee(dto.getSubActivityPlanCode(), itemCacheList);
    }

    private List<SubComActivityPlanBudgetDto> findAndBuildBudgetDate(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        Pageable pageable = Pageable.ofSize((int)1000);
        SubComActivityPlanBudgetDto selectDto = new SubComActivityPlanBudgetDto();
        selectDto.setYearMonthLy(dto.getFeeYearMonth());
        selectDto.setOrgCode(dto.getOrgCode());
        ArrayList planBudgetList = null;
        SubComActivityPlanBudgetDto budgetDto = new SubComActivityPlanBudgetDto();
        budgetDto.setOrgCode(dto.getOrgCode());
        budgetDto.setFeeYearMonth(dto.getFeeYearMonth());
        Page<SubComActivityPlanBudgetVo> planBudgetPage = this.findSubBudgetForecastByConditions(pageable, budgetDto, itemCacheList);
        Optional<Long> total = Optional.ofNullable(planBudgetPage).map(Page::getTotal);
        if (total.isPresent()) {
            planBudgetList = new ArrayList(total.get().intValue());
            planBudgetList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planBudgetPage.getRecords(), SubComActivityPlanBudgetVo.class, SubComActivityPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]));
            while (planBudgetPage.hasNext()) {
                pageable = pageable.next();
                planBudgetPage = this.findSubBudgetForecastByConditions(pageable, null, itemCacheList);
                planBudgetList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planBudgetPage.getRecords(), SubComActivityPlanBudgetVo.class, SubComActivityPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]));
            }
        }
        if (CollectionUtils.isEmpty(planBudgetList)) {
            return Lists.newArrayList();
        }
        return planBudgetList;
    }

    private void buildCommonCode(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        long count = itemCacheList.stream().filter(itemCache -> StringUtils.isEmpty((CharSequence)itemCache.getSubActivityPlanItemCode())).count();
        List codeList = Lists.newArrayList();
        if (count > 0L) {
            codeList = this.generateCodeService.generateCode("F-", (int)count, Integer.valueOf(8), 1L, TimeUnit.DAYS);
        }
        Iterator codeIt = codeList.iterator();
        String tenantCode = TenantUtils.getTenantCode();
        itemCacheList.forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item.getSubActivityPlanItemCode())) {
                item.setSubActivityPlanItemCode((String)codeIt.next());
            }
            item.setSubActivityPlanCode(dto.getSubActivityPlanCode());
            item.setSubActivityPlanName(dto.getSubActivityPlanName());
            item.setTenantCode(tenantCode);
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setActivityStatus(SubPlanStatusEnum.CREATE.getCode());
            if (!CollectionUtils.isEmpty((Collection)item.getItemFeeList())) {
                item.getItemFeeList().forEach(fee -> {
                    fee.setBusinessUnitCode(dto.getBusinessUnitCode());
                    fee.setSubActivityPlanCode(dto.getSubActivityPlanCode());
                    fee.setSubActivityPlanName(dto.getSubActivityPlanName());
                    fee.setSubActivityPlanItemCode(item.getSubActivityPlanItemCode());
                    fee.setSubActivityPlanItemName(item.getSubActivityPlanItemName());
                    fee.setTenantCode(tenantCode);
                    fee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                });
            }
        });
        if (!CollectionUtils.isEmpty((Collection)dto.getBudgetList())) {
            dto.getBudgetList().forEach(budget -> {
                budget.setSubActivityPlanCode(dto.getSubActivityPlanCode());
                budget.setTenantCode(tenantCode);
                budget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
    }

    private void validateItemValueAndGenerateItemFee(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        Validate.notEmpty(itemCacheList, (String)"\u65b9\u6848\u5185\u5bb9\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal salesAmount = BigDecimal.ZERO;
        Date date = new Date();
        for (SubComActivityPlanItemDto item : itemCacheList) {
            Validate.notBlank((CharSequence)item.getOrgCode(), (String)"\u6267\u884c\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getOrgName(), (String)"\u6267\u884c\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getActivityFormName(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getActivityTypeCode(), (String)"\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getActivityTypeName(), (String)"\u6d3b\u52a8\u5206\u7c7b\u540d\u79f0\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getBudgetItemName(), (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getFeeSourceCode(), (String)"\u8d39\u7528\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)item.getTotalCost(), (String)"\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)item.getExpectSalesAmount(), (String)"\u9884\u8ba1\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            BigDecimal totalCost = Optional.ofNullable(item.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal expectSalesAmount = Optional.ofNullable(item.getExpectSalesAmount()).orElse(BigDecimal.ZERO);
            applyAmount = applyAmount.add(totalCost);
            salesAmount = salesAmount.add(expectSalesAmount);
            item.setFeeYearMonth(dto.getFeeYearMonth());
            SubComActivityPlanItemFeeDto feeDto = new SubComActivityPlanItemFeeDto();
            feeDto.setSubActivityPlanItemName(item.getSubActivityPlanItemName());
            feeDto.setBudgetItemCode(item.getBudgetItemCode());
            feeDto.setBudgetItemName(item.getBudgetItemName());
            feeDto.setInitialAmount(item.getTotalCost());
            feeDto.setBeforeAmount(BigDecimal.ZERO);
            feeDto.setCurOperationAmount(item.getTotalCost());
            feeDto.setBalanceAmount(item.getTotalCost());
            feeDto.setOperationType(ForecastOperationTypeEnum.INIT.getCode());
            feeDto.setSortAsc(Long.valueOf(Long.parseLong(DateUtil.format((Date)date, (String)"yyyyMMddHHmmss") + "0")));
            ArrayList<SubComActivityPlanItemFeeDto> feeDtoList = new ArrayList<SubComActivityPlanItemFeeDto>();
            feeDtoList.add(feeDto);
            item.setItemFeeList(feeDtoList);
            item.setResidueAmount(item.getTotalCost());
            item.setUsedAmount(BigDecimal.ZERO);
        }
        dto.setApplyAmount(applyAmount);
        dto.setSalesAmount(salesAmount);
    }

    private void validateValue(SubComActivityPlanDto dto) {
        Validate.notBlank((CharSequence)dto.getSubActivityPlanName(), (String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getSubActivityPlanType())) {
            dto.setSubActivityPlanType("1");
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        }
        Validate.notBlank((CharSequence)dto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u5206\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u5206\u5b50\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u6570\u636e\uff01");
        }
        List<SubComActivityPlan> subPlanList = this.subComActivityPlanRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(subPlanList)) {
            return;
        }
        List passList = subPlanList.stream().filter(x -> ProcessStatusEnum.PASS.getDictCode().equals(x.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(x.getProcessStatus()) || ProcessStatusEnum.COLSE.getDictCode().equals(x.getProcessStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(passList), (String)"\u5ba1\u6279\u901a\u8fc7\u3001\u5ba1\u6279\u4e2d\u3001\u5df2\u5173\u95ed\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff01\uff01\uff01", (Object[])new Object[0]);
        subPlanList.forEach(plan -> plan.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        List subPlanCodes = subPlanList.stream().map(SubComActivityPlan::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        this.subComActivityPlanRepository.updateBatchById(subPlanList);
        this.subComActivityPlanItemService.deleteBySubPlanCodes(subPlanCodes);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(SubComActivityPlanApproveSubmitDto dto) {
        List<SubComActivityPlan> entityList = this.subComActivityPlanRepository.listByIds(dto.getIds(), DelFlagStatusEnum.NORMAL.getCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entityList) ? 1 : 0) != 0, (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        ArrayList<String> planCodes = new ArrayList<String>(entityList.size());
        for (SubComActivityPlan entity : entityList) {
            if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
                throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u65b9\u6848[" + entity.getSubActivityPlanCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
            }
            planCodes.add(entity.getSubActivityPlanCode());
        }
        this.commitProcess(planCodes, dto);
    }

    private void commitProcess(List<String> planCodes, SubComActivityPlanApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNoList(dto.getIds());
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("SUB_COM_ACTIVITY_PLAN_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        this.subComActivityPlanRepository.updateProcessStatusAndProcessNo(dto.getIds(), ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo());
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes, SubPlanStatusEnum.COMMIT.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void passProcessBusiness(String processNo, String processStatus) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return;
        }
        List<String> planCodes = this.subComActivityPlanRepository.findPlanCodeByProcessNo(processNo);
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        this.subComActivityPlanRepository.updateProcessStatusByProcessNo(processNo, processStatus);
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes, SubPlanStatusEnum.EXECUTING.getCode());
    }

    @Transactional
    public void failProcessBusiness(String processNo, String processStatus) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return;
        }
        List<String> planCodes = this.subComActivityPlanRepository.findPlanCodeByProcessNo(processNo);
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        this.subComActivityPlanRepository.updateProcessStatusByProcessNo(processNo, processStatus);
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes, SubPlanStatusEnum.CREATE.getCode());
    }

    public List<SubComActivityPlanVo> findByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanVo> planList = this.subComActivityPlanRepository.findByProcessNo(processNo);
        if (!CollectionUtils.isEmpty(planList)) {
            return Lists.newArrayList();
        }
        List subPlanCodes = planList.stream().map(SubComActivityPlanVo::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        List planItemList = this.subComActivityPlanItemService.findBySubPlanCodes(subPlanCodes);
        Map<String, List<SubComActivityPlanItemVo>> planItemMap = planItemList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemVo::getSubActivityPlanCode));
        planList.forEach(plan -> {
            List items = (List)planItemMap.get(plan.getSubActivityPlanCode());
            plan.setItemList(items);
        });
        return planList;
    }

    public List<SubComActivityPlanVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List planList = this.subComActivityPlanRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)planList)) {
            return Lists.newArrayList();
        }
        List subPlanCodes = planList.stream().map(SubComActivityPlan::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        List planItemList = this.subComActivityPlanItemService.findBySubPlanCodes(subPlanCodes);
        List planVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planList, SubComActivityPlan.class, SubComActivityPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<SubComActivityPlanItemVo>> planItemMap = planItemList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemVo::getSubActivityPlanCode));
        planVos.forEach(plan -> {
            List items = (List)planItemMap.get(plan.getSubActivityPlanCode());
            plan.setItemList(items);
        });
        return planVos;
    }

    public SubComActivityPlanVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComActivityPlan plan = (SubComActivityPlan)((Object)this.subComActivityPlanRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)plan)) {
            return null;
        }
        SubComActivityPlanVo planVo = (SubComActivityPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)plan, SubComActivityPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        return planVo;
    }

    public Page<SubComActivityPlanBudgetVo> findSubBudgetForecastByConditions(Pageable pageable, SubComActivityPlanBudgetDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        FacturerUserDetails loginUserDetails;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanBudgetDto());
        SubComBudgetForecastDto selectDto = new SubComBudgetForecastDto();
        Page resultPage = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isBlank((CharSequence)dto.getFeeYearMonth())) {
            dto.setFeeYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        }
        if (StringUtils.isBlank((CharSequence)dto.getOrgCode()) && !Objects.isNull(loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class))) {
            dto.setOrgCode(loginUserDetails.getOrgCode());
        }
        selectDto.setYearMonthLy(dto.getFeeYearMonth());
        selectDto.setOrgCode(dto.getOrgCode());
        selectDto.setBudgetItemCode(dto.getBudgetItemCode());
        selectDto.setBudgetItemName(dto.getBudgetItemName());
        selectDto.setFeeSourceCode(dto.getFeeSourceCode());
        Page subBudgetForecastPage = this.subComBudgetForecastService.findSubBudgetForecastByConditions(pageable, selectDto);
        if (CollectionUtils.isEmpty((Collection)subBudgetForecastPage.getRecords())) {
            return resultPage;
        }
        if (!StringUtils.isBlank((CharSequence)dto.getCacheKey()) && Objects.isNull(itemCacheList)) {
            itemCacheList = this.subComActivityPlanItemCacheService.findCacheList(dto.getCacheKey());
        }
        Map<Object, Object> itemCacheMap = new HashMap();
        if (!CollectionUtils.isEmpty(itemCacheList)) {
            itemCacheList = itemCacheList.stream().filter(i -> !Objects.isNull(i.getTotalCost())).collect(Collectors.toList());
            itemCacheMap = itemCacheList.stream().collect(Collectors.groupingBy(b -> b.getBudgetItemCode() + b.getFeeSourceCode()));
        }
        ArrayList<SubComActivityPlanBudgetVo> planBudgeList = new ArrayList<SubComActivityPlanBudgetVo>(subBudgetForecastPage.getRecords().size());
        for (SubComBudgetForecastVo budgetForecast : subBudgetForecastPage.getRecords()) {
            List planItemCacheList;
            SubComActivityPlanBudgetVo budgetVo = new SubComActivityPlanBudgetVo();
            budgetVo.setBudgetItemCode(budgetForecast.getBudgetItemCode());
            budgetVo.setBudgetItemName(budgetForecast.getBudgetItemName());
            budgetVo.setFeeSourceCode(budgetForecast.getFeeSourceCode());
            budgetVo.setYearMonthLy(budgetForecast.getYearMonthLy());
            budgetVo.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
            BigDecimal initialAmount = Optional.ofNullable(budgetForecast.getFirstBudgetAmount()).orElse(BigDecimal.ZERO);
            budgetVo.setInitialAmount(initialAmount);
            budgetVo.setPlanUseAmount(BigDecimal.ZERO);
            if (!org.springframework.util.CollectionUtils.isEmpty(itemCacheMap) && CollectionUtils.isNotEmpty((Collection)(planItemCacheList = (List)itemCacheMap.get(budgetForecast.getBudgetItemCode() + budgetForecast.getFeeSourceCode())))) {
                BigDecimal planUseTotalCost = planItemCacheList.stream().map(SubComActivityPlanItemDto::getTotalCost).reduce(BigDecimal.ZERO, BigDecimal::add);
                budgetVo.setPlanUseAmount(planUseTotalCost);
            }
            SubPlanCallSubActivityDesignEventDto eventDto = new SubPlanCallSubActivityDesignEventDto();
            eventDto.setBudgetItemCode(budgetForecast.getBudgetItemCode());
            eventDto.setYearMonthLy(budgetForecast.getYearMonthLy());
            eventDto.setOrgCode(budgetForecast.getOrgCode());
            eventDto.setFeeSourceCode(budgetForecast.getFeeSourceCode());
            eventDto.setBusinessFormatCode(budgetForecast.getBusinessFormatCode());
            eventDto.setBusinessUnitCode(budgetForecast.getBusinessUnitCode());
            SerializableBiConsumer & Serializable findBudgetUsedAmountSum = SubPlanCallSubActivityDesignEventListener::findBudgetUsedAmountSum;
            EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, SubPlanCallSubActivityDesignEventListener.class, (SerializableBiConsumer)findBudgetUsedAmountSum);
            if (!Objects.isNull(eventResponse)) {
                BudgetAmountResponse resp = (BudgetAmountResponse)eventResponse;
                budgetVo.setSubDesignUseAmount(resp.getBudgetAmount());
            }
            BigDecimal planUseAmount = Optional.ofNullable(budgetVo.getPlanUseAmount()).orElse(BigDecimal.ZERO);
            BigDecimal subDesignUseAmount = Optional.ofNullable(budgetVo.getSubDesignUseAmount()).orElse(BigDecimal.ZERO);
            BigDecimal remainderAmount = initialAmount.subtract(planUseAmount).subtract(subDesignUseAmount);
            if (!FeeSourceEnum.AUTO_FEE.getCode().equals(budgetVo.getFeeSourceCode())) {
                Validate.isTrue((BigDecimal.ZERO.compareTo(remainderAmount) <= 0 ? 1 : 0) != 0, (String)(budgetForecast.getBudgetItemCode() + "\u9884\u7b97\u9879\u76ee\uff0c\u5269\u4f59\u53ef\u7528\u91d1\u989d\u4e0d\u8db3!"), (Object[])new Object[0]);
            }
            budgetVo.setRemainderAmount(remainderAmount);
            planBudgeList.add(budgetVo);
        }
        resultPage.setRecords(planBudgeList);
        return resultPage;
    }
}

