package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description:分子活动方案-预算信息dto
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanBudgetDto", description = "TPM-分子活动方案-预算信息dto")
public class SubComActivityPlanBudgetDto extends TenantFlagOpDto {

    @ApiModelProperty("方案编码")
    private String subActivityPlanCode;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("分子公司预算预测编码")
    private String budgetForecastCode;

    @ApiModelProperty("费用来源[数据字典:tpm_fee_source]")
    private String feeSourceCode;

    @ApiModelProperty(name = "年月")
    private String yearMonthLy;

    @ApiModelProperty("期初可用金额")
    private BigDecimal initialAmount;

    @ApiModelProperty("方案使用金额")
    private BigDecimal planUseAmount;

    @ApiModelProperty("分子活动规划使用金额（未关联方案）")
    private BigDecimal subDesignUseAmount;

    @ApiModelProperty("剩余可用金额")
    private BigDecimal remainderAmount;

    //===冗余 查询使用====
    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    @ApiModelProperty("方案内容CacheKey")
    private String cacheKey;

    @ApiModelProperty(name = "查询使用 年月")
    private String feeYearMonth;

    //====查询使用
    @ApiModelProperty("方案名称")
    private String subActivityPlanName;

    @ApiModelProperty("方案流程编码")
    private String processNo;

}
