package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description:分子活动方案dto
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanDto", description = "TPM-分子活动方案dto")
public class SubComActivityPlanDto extends TenantFlagOpDto {

    @ApiModelProperty("方案内容集合")
    private List<SubComActivityPlanItemDto> itemList;

    /**
     * 方案预算信息集合 （审批通过前，页面实时查询预算信息展示；审批通过时，才会保存一份预算快照）
     */
    @ApiModelProperty("方案预算信息集合")
    private List<SubComActivityPlanBudgetDto> budgetList;


    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 组织编码/归属部门/分子公司编码
     */
    @ApiModelProperty(name = "组织编码/归属部门/分子公司编码", notes = "")
    private String orgCode;

    /**
     * 组织名称/归属部门/分子公司名称
     */
    @ApiModelProperty(name = "组织名称/归属部门/分子公司名称", notes = "")
    private String orgName;

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    private String subActivityPlanCode;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    private String subActivityPlanName;

    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    private String subActivityPlanType;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonth;

    /**
     * 方案金额
     */
    @ApiModelProperty(name = "方案金额")
    private BigDecimal applyAmount;

    /**
     * 汇总销售额
     */
    @ApiModelProperty("汇总销售额")
    private BigDecimal salesAmount;

    /**
     * 流程编码
     */
    @ApiModelProperty("流程编码")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

}
