package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description:分子活动方案-方案内容明细dto
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanItemDto", description = "TPM-分子活动方案-方案内容明细dto")
public class SubComActivityPlanItemDto extends TenantFlagOpDto {

    @ApiModelProperty("使用预算明细")
    private List<SubComActivityPlanItemFeeDto> itemFeeList;


    @ApiModelProperty("方案编码")
    private String subActivityPlanCode;

    @ApiModelProperty("方案名称")
    private String subActivityPlanName;

    @ApiModelProperty("方案明细编码")
    private String subActivityPlanItemCode;

    @ApiModelProperty("方案明细名称")
    private String subActivityPlanItemName;

    @ApiModelProperty("方案状态")
    private String activityStatus;

    @ApiModelProperty(name = "执行部门编码(头表组织的下级组织编码)")
    private String orgCode;

    @ApiModelProperty(name = "执行部门名称(头表组织的下级组织名称)")
    private String orgName;

    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动力度说明")
    private String activityIntensity;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty(name = "费用来源")
    private String feeSourceCode;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;

    @ApiModelProperty("费用金额")
    private BigDecimal totalCost;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty("预计销售额")
    private BigDecimal expectSalesAmount;

    @ApiModelProperty("核销条件")
    private String auditCondition;

    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;

    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal residueAmount;

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    @ApiModelProperty("流程编码")
    private String itemProcessNo;

    @ApiModelProperty("年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonth;

    //=======冗余 查询使用======
    @ApiModelProperty("方案编码集合")
    private List<String> subActivityPlanCodeList;
    @ApiModelProperty("头表创建提交审批编码")
    private String processNo;

}
