package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Objects;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/21
 */
@Getter
public enum AuditConditionEnum {

    /**
     * 制度核销
     */
    zdhx("1", "制度核销"),

    /**
     * 自定义核销
     */
    zdyhx("2", "自定义核销"),

    /**
     * 无核销条件
     */
    whxtj("no_dudit_condition", "无核销条件"),

    ;

    private final String code;

    private final String des;

    AuditConditionEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    /**
     * 根据des获取
     *
     * @param des des
     * @return {@link String}
     */
    public static String findByDes(String des){
        if (StrUtil.isBlank(des)){
            return StrUtil.EMPTY;
        }
        for (AuditConditionEnum value : AuditConditionEnum.values()) {
            if (Objects.equals(value.getDes(),des)){
                return value.code;
            }
        }
        return StrUtil.EMPTY;
    }

}
