package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description:分子公司方案状态枚举 字典molecular_programs
 * @Author qiancheng
 * @Date 2023/6/30
 */
@Getter
public enum SubPlanStatusEnum {

    CREATE("1","创建"),
    COMMIT("2","审批中"),
    EXECUTING("3","执行中"),
    CLOSE_COMMIT("4","关闭审批中"),
    CLOSE_REJECT("5","关闭审批驳回"),
    CLOSE("6","已关闭"),
    END("7","已结束"),
    CHANGE_COMMIT("8","变更审批中");

    private final String code;
    private final String des;

    SubPlanStatusEnum(String code , String des) {
        this.code = code;
        this.des = des;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            SubPlanStatusEnum[] values = values();
            SubPlanStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                SubPlanStatusEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }
}
