package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Description:分子活动方案-方案内容明细  --服务
 * @Author qiancheng
 * @Date 2023/6/13
 */
public interface SubComActivityPlanItemService {

    /**
     * 新增编辑
     * @param update
     * @param dto
     * @param itemCacheList
     */
    void saveItem(boolean update,SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList);

    /**
     * 更据分子方案编码删除
     * @param subPlanCodes
     */
    void deleteBySubPlanCodes(List<String> subPlanCodes);

    /**
     * 更据分子方案编码查询
     *
     * @param subPlanCodes
     * @return
     */
    List<SubComActivityPlanItemVo> findBySubPlanCodes(List<String> subPlanCodes);

    /**
     * 更据分子方案编码查询
     *
     * @param subPlanCode
     * @return
     */
    List<SubComActivityPlanItemVo> findBySubPlanCode(String subPlanCode);

    void closeSubmitApproval(SubComActivityPlanApproveSubmitDto dto);

    Page<SubComActivityPlanItemVo> closeFindItem(Pageable pageable, SubComActivityPlanItemDto dto);

    Page<SubComActivityPlanItemVo> findByItemProcessNo(Pageable pageable, String itemProcessNo);

    List<SubComActivityPlanItemVo> findByItemCodes(List<String> itemCodes);

    void updateActivityStatusByProcessNo(List<String> planCodes, String code);

    Page<SubComActivityPlanItemFeeVo> findItemFeeByItemCode(Pageable pageable, String itemCode);

    void closeFailProcessBusiness(String processNo, String processStatus);

    void closePassProcessBusiness(String processNo, String code);

    Page<SubComActivityPlanItemVo> findPlanItemByConditions(Pageable pageable, SubComActivityPlanItemDto dto);

    /**
     * 规划关闭生成对应方案内容预算使用记录
     * @param subPlanItemFeeDtoList
     */
    void generateItemFeeByDesignClosed(List<SubComActivityPlanItemFeeDto> subPlanItemFeeDtoList);

    void useSubPlanItemFee(List<SubComActivityPlanItemFeeDto> subPlanItemFeeList);

    void updateReturnAmount(List<SubComActivityPlanItemDto> updateSubPlanItemList);

    Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityPlanItemDto dto);
}
