package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Description:分子活动方案 --服务
 * @Author qiancheng
 * @Date 2023/6/13
 */
public interface SubComActivityPlanService {

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComActivityPlanVo> findByConditions(Pageable pageable, SubComActivityPlanDto dto);

    /**
     * 新增编辑
     *
     * @param dto
     * @param cacheKey
     */
    void create(SubComActivityPlanDto dto, String cacheKey);

    /**
     * 删除数据
     *
     * @param ids
     */
    void delete(List<String> ids);

    /**
     *提交审批
     *
     * @param dto
     */
    void submitApproval(SubComActivityPlanApproveSubmitDto dto);

    /**
     * 审批通过
     * @param processNo
     * @param processStatus
     */
    void passProcessBusiness(String processNo, String processStatus);

    /**
     * 审批驳回、追回
     * @param processNo
     * @param processStatus
     */
    void failProcessBusiness(String processNo, String processStatus);

    /**
     * 更据流程编码查详情
     * @param processNo
     * @return
     */
    List<SubComActivityPlanVo> findByProcessNo(String processNo);

    /**
     * 更据id查详情
     * @param ids
     * @return
     */
    List<SubComActivityPlanVo> findByIds(List<String> ids);

    /**
     * 更据id查详情
     * @param id
     * @return
     */
    SubComActivityPlanVo findById(String id);

    /**
     * 分页查询分子预算预测信息
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComActivityPlanBudgetVo> findSubBudgetForecastByConditions(Pageable pageable, SubComActivityPlanBudgetDto dto,List<SubComActivityPlanItemDto> itemCacheList);
}
