package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description:分子活动方案-预算信息vo
 * @Author admin
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanBudgetVo", description = "TPM-分子活动方案-预算信息vo")
public class SubComActivityPlanBudgetVo extends TenantFlagOpVo {

    @ApiModelProperty("方案编码")
    private String subActivityPlanCode;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("分子公司预算预测编码")
    private String budgetForecastCode;

    @ApiModelProperty("费用来源[数据字典:tpm_fee_source]")
    private String feeSourceCode;

    @ApiModelProperty(name = "年月")
    private String yearMonthLy;

    @ApiModelProperty("期初可用金额")
    private BigDecimal initialAmount;

    @ApiModelProperty("方案使用金额")
    private BigDecimal planUseAmount;

    @ApiModelProperty("分子活动规划使用金额（未关联方案）")
    private BigDecimal subDesignUseAmount;

    @ApiModelProperty("剩余可用金额")
    private BigDecimal remainderAmount;

    //===关联展示字段===
    @ApiModelProperty("方案名称")
    private String subActivityPlanName;
    @ApiModelProperty("方案明细名称")
    private String subActivityPlanItemName;

}
