package com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description:分子活动方案内容明细-使用明细vo
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanItemFeeVo", description = "TPM-分子活动方案内容明细-使用明细vo")
public class SubComActivityPlanItemFeeVo extends TenantFlagOpVo {

    @ApiModelProperty("方案编码")
    private String subActivityPlanCode;

    @ApiModelProperty("方案名称")
    private String subActivityPlanName;

    @ApiModelProperty("方案明细编码")
    private String subActivityPlanItemCode;

    @ApiModelProperty("方案明细名称")
    private String subActivityPlanItemName;


    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("期初金额")
    private BigDecimal initialAmount;

    @ApiModelProperty("操作前金额")
    private BigDecimal beforeAmount;

    @ApiModelProperty("当前操作金额")
    private BigDecimal curOperationAmount;

    @ApiModelProperty("操作后余额")
    private BigDecimal balanceAmount;

    @ApiModelProperty("业务编码/分子活动规划明细编码")
    private String businessCode;

    @ApiModelProperty("分子活动规划编码")
    private String activityDesignCode;

    @ApiModelProperty("分子活动规划名称")
    private String activityDesignName;

    @ApiModelProperty("核销编码")
    private String auditCode;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("用于排序")
    private Long sortAsc;

    @ApiModelProperty("操作类型")
    private String operationType;
}
