package com.biz.crm.tpm.business.subsidiary.year.budget.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName TpmSubsidiaryYearBudgetController
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Api(tags = "分子公司年度预算相关接口")
@Slf4j
@RestController
@RequestMapping("/v1/subsidiary/year/budget")
public class TpmSubsidiaryYearBudgetController {

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetService tpmSubsidiaryYearBudgetService;

    @GetMapping("findById")
    @ApiOperation("根据id查询详情")
    public Result<TpmSubsidiaryYearBudgetVo> findById(@RequestParam("id") String id){
        try {
            return Result.ok(tpmSubsidiaryYearBudgetService.findById(id));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("create")
    @ApiOperation("创建分子公司年度预算")
    public Result<?> create(@RequestBody TpmSubsidiaryYearBudgetDto dto){
        try {
            tpmSubsidiaryYearBudgetService.create(dto);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PatchMapping("edit")
    @ApiOperation("创建分子公司年度预算")
    public Result<?> edit(@RequestBody TpmSubsidiaryYearBudgetDto dto){
        try {
            tpmSubsidiaryYearBudgetService.update(dto);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @DeleteMapping("delete")
    @ApiOperation("删除分子公司年度预算")
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids){
        try {
            tpmSubsidiaryYearBudgetService.delete(ids);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "分页查询所有明细数据")
    @GetMapping("findDetailByConditions")
    public Result<Page<TpmSubsidiaryYearBudgetDetailExportVo>> findDetailByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                      @ApiParam(name = "dto", value = "分子年度预算") TpmSubsidiaryYearBudgetDto dto) {
        try {
            return Result.ok(this.tpmSubsidiaryYearBudgetService.findDetailByConditions(pageable, dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
