package com.biz.crm.tpm.business.subsidiary.year.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import liquibase.util.MD5Util;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName TpmSubsidiaryYearBudgetEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@ApiModel(value = "TpmSubsidiaryYearBudgetEntity", description = "TPM-分子年度预算")
@TableName("tpm_subsidiary_year_budget")
@Getter
@Setter
@Entity(name = "tpm_subsidiary_year_budget")
@Table(name = "tpm_subsidiary_year_budget", indexes = {@Index(name = "tpm_subsidiary_year_budget_index1", unique = true, columnList = "year_budget_code"),
        @Index(name = "tpm_unique_index", unique = true, columnList = "md5_unique_key")})
@org.hibernate.annotations.Table(appliesTo = "tpm_subsidiary_year_budget", comment = "TPM-分子年度预算")
public class TpmSubsidiaryYearBudgetEntity extends TenantFlagOpEntity {

    /**
     * 年度预算编码
     */
    @ApiModelProperty(name = "年度预算编码", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年份
     */
    @ApiModelProperty(name = "年份", notes = "")
    @Column(name = "year_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年份 '")
    private String yearLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 部门编码
     */
    @ApiModelProperty(name = "部门编码", notes = "")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门编码 '")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(name = "部门名称", notes = "")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '部门名称 '")
    private String departmentName;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(name = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(name = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构ERP编码
     */
    @ApiModelProperty("销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "销售部门编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码 '")
    private String salesOrgCode;

    /**
     * 销售部门Erp编码
     */
    @ApiModelProperty(name = "销售部门Erp编码", notes = "")
    @Column(name = "sales_org_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门Erp编码 '")
    private String salesOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组Erp编码 '")
    private String salesGroupCode;

    /**
     * 销售组Erp编码
     */
    @ApiModelProperty(name = "salesGroupErpCode",value = "销售组Erp编码",notes = "销售组Erp编码")
    @Column(name = "sales_group_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组Erp编码 '")
    private String salesGroupErpCode;

    /**
     * 销售组名称
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组名称",notes = "销售组名称")
    @Column(name = "sales_group_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组名称 '")
    private String salesGroupName;

    /**
     * 销售组织层级编码
     */
    @ApiModelProperty(name = "销售组织层级编码", notes = "")
    @Column(name = "sales_org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级编码 '")
    private String salesOrgLevelCode;

    /**
     * 销售组织层级名称
     */
    @ApiModelProperty(name = "销售组织层级名称", notes = "")
    @Column(name = "sales_org_level_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级名称 '")
    private String salesOrgLevelName;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    @Column(name = "terminal_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道编码 '")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    @Column(name = "terminal_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店渠道名称 '")
    private String terminalChannelName;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    @Column(name = "terminal_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道层级 '")
    private String terminalChannelLevelCode;

    /**
     * 系统编码
     */
    @ApiModelProperty(name = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(name = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户erp编码
     */
    @ApiModelProperty(name = "客户erp编码", notes = "")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户erp编码 '")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "")
    @Column(name = "region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称 '")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码 '")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "")
    @Column(name = "activity_form_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称 '")
    private String activityFormName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty(name = "活动类型编码", notes = "")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码 '")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty(name = "活动类型名称", notes = "")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型名称 '")
    private String activityTypeName;

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 预算总点数
     */
    @ApiModelProperty(name = "预算总点数", notes = "")
    @Column(name = "budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算总点数 '")
    private BigDecimal budgetTotalPoint;

    /**
     * 年度力度
     */
    @ApiModelProperty(name = "年度力度", notes = "")
    @Column(name = "budget_intensity", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度力度 '")
    private String budgetIntensity;
    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    @Column(name = "budget_intensity_numerator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分子 '")
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    @Column(name = "budget_intensity_denominator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分母 '")
    private BigDecimal budgetIntensityDenominator;

    /**
     * 预算总金额
     */
    @ApiModelProperty(name = "预算总金额", notes = "")
    @Column(name = "budget_total_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算总金额 '")
    private BigDecimal budgetTotalAmount;

    /**
     * 总目标量
     */
    @ApiModelProperty(name = "总目标量", notes = "")
    @Column(name = "total_goal_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '总目标量 '")
    private BigDecimal totalGoalQuantity;

    /**
     * 策略关联金额
     */
    @ApiModelProperty(name = "策略关联金额", notes = "")
    @Column(name = "strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '策略关联金额 '")
    private BigDecimal strategyAmount;

    /**
     * 剩余可关联金额
     */
    @ApiModelProperty(name = "剩余可关联金额", notes = "")
    @Column(name = "remainder_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '剩余可关联金额 '")
    private BigDecimal remainderAmount;

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "渠道编码", notes = "")
    @Column(name = "channel", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码 '")
    private String channel;

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "渠道名称", notes = "")
    @Column(name = "channel_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '渠道名称 '")
    private String channelName;

    /**
     * 唯一键
     */
    @ApiModelProperty(name = "唯一键", notes = "")
    @Column(name = "md5_unique_key", length = 255, columnDefinition = "VARCHAR(60) COMMENT '唯一键 '")
    private String md5UniqueKey;

    @ApiModelProperty(name = "预算类型", notes = "")
    @Column(name = "budget_type", length = 16, columnDefinition = "VARCHAR(16) COMMENT '预算类型;数据字典[tpm_sub_com_budget_type]'")
    private String budgetType;

    @ApiModelProperty(name = "附件总数", notes = "")
    @Column(name = "attachment_number", columnDefinition = "DECIMAL(12) COMMENT '附件总数'")
    private BigDecimal attachmentNumber;

    public String generateUniqueKey(){
        return this.yearLy + MD5Util.computeMD5(this.businessFormatCode + this.businessUnitCode + this.groupCode + ifNull(this.orgCode)
                + this.budgetItemCode + ifNull(this.salesInstitutionCode) + ifNull(this.salesOrgCode) + this.activityTypeCode + "_"
                + ifNull(this.departmentCode) + "_" + ifNull(this.customerCode) + "_" + ifNull(this.terminalCode) + "_" + ifNull(this.systemCode)
                + "_" + ifNull(this.productBrandCode) + "_" + ifNull(this.productCategoryCode)+ "_" + ifNull(this.productItemCode) + "_" + ifNull(this.productCode)
                + "_" + ifNull(this.activityFormCode) + "_" + ifNull(this.customerChannelCode));
    }

    /**
     * 字符串为空返回空字符串
     * @author jiangyin
     * @param s 校验字符串
     * @return 返回结果
     */
    private String ifNull(String s){
        if(StringUtils.isEmpty(s)){
            return "";
        }
        return s;
    }


}
