package com.biz.crm.tpm.business.subsidiary.year.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName TpmSubsidiaryYearBudgetMonthDetailEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@ApiModel(value = "TpmSubsidiaryYearBudgetMonthDetailEntity", description = "TPM-分子年度预算月明细")
@TableName("tpm_subsidiary_year_budget_month_detail")
@Getter
@Setter
@Entity(name = "tpm_subsidiary_year_budget_month_detail")
@Table(name = "tpm_subsidiary_year_budget_month_detail",
        indexes = {@Index(name = "tpm_subsidiary_year_budget_index1", columnList = "year_budget_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_subsidiary_year_budget_month_detail", comment = "TPM-分子年度预算月明细")
public class TpmSubsidiaryYearBudgetMonthDetailEntity extends TenantFlagOpEntity {

    /**
     * 年度预算编码
     */
    @ApiModelProperty(name = "年度预算编码", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    @ApiModelProperty(name = "分子年度预算详情-类型", notes = "")
    @Column(name = "budget_detail_type", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '分子年度预算详情-类型 '")
    private String budgetDetailType;

    @ApiModelProperty(name = "分子年度预算详情-月份", notes = "")
    @Column(name = "budget_detail_month", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '分子年度预算详情-月份 '")
    private String budgetDetailMonth;

    @ApiModelProperty(name = "分子年度预算详情-金额", notes = "")
    @Column(name = "budget_detail_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '分子年度预算详情-金额 '")
    private BigDecimal budgetDetailAmount;

}
