package com.biz.crm.tpm.business.subsidiary.year.budget.local.event;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetLogDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.event.TpmSubsidiaryYearBudgetLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName TpmSubsidiaryYearBudgetLogEventListenerImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/17
 */
@Component
public class TpmSubsidiaryYearBudgetLogEventListenerImpl implements TpmSubsidiaryYearBudgetLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;


    /**
     * 创建
     *
     * @param dto
     * @return void
     * @author: jiangyin
     * @version: v1.0.0
     * @date: 2022.11.9 18:27
     */
    @Override
    public void onCreate(TpmSubsidiaryYearBudgetLogDto dto) {
        // 新对象
        TpmSubsidiaryYearBudgetDto newest = dto.getNewest();
        // 旧对象
        TpmSubsidiaryYearBudgetDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 删除
     *
     * @param dto
     * @return void
     * @author: jiangyin
     * @version: v1.0.0
     * @date: 2022.11.9 18:27
     */
    @Override
    public void onDelete(TpmSubsidiaryYearBudgetLogDto dto) {
        // 新对象
        TpmSubsidiaryYearBudgetDto newest = dto.getNewest();
        // 旧对象
        TpmSubsidiaryYearBudgetDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 更新
     *
     * @param dto
     * @return void
     * @author: jiangyin
     * @version: v1.0.0
     * @date: 2022.11.9 18:27
     */
    @Override
    public void onUpdate(TpmSubsidiaryYearBudgetLogDto dto) {
        // 新对象
        TpmSubsidiaryYearBudgetDto newest = dto.getNewest();
        // 旧对象
        TpmSubsidiaryYearBudgetDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

}
