package com.biz.crm.tpm.business.subsidiary.year.budget.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.constant.TpmSubsidiaryYearBudgetConstant;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetDetailExportVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * @Author : dengwei
 * @Date :2023/7/3  15:53
 * @Description: 促销政策范围导出
 */
@Component
@Slf4j
public class SubComYearBudgetDetailExportProcess implements ExportProcess<TpmSubsidiaryYearBudgetDetailExportVo> {

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetService tpmSubsidiaryYearBudgetService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        Pageable pageable = PageRequest.of(1, 1);
        params = this.convertEuropaParam(params);
        TpmSubsidiaryYearBudgetDto dto = this.convertParams(params);
        Page<TpmSubsidiaryYearBudgetDetailExportVo> pageResult = this.tpmSubsidiaryYearBudgetService.findDetailByConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    @Transactional(readOnly = true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      分子年度预算明细导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        TpmSubsidiaryYearBudgetDto dto = convertParams(params);
        Page<TpmSubsidiaryYearBudgetDetailExportVo> pageResult = this.tpmSubsidiaryYearBudgetService.findDetailByConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<TpmSubsidiaryYearBudgetDetailExportVo> records = pageResult.getRecords();
        adjustData(records);
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(List<TpmSubsidiaryYearBudgetDetailExportVo> data) {
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
                DictConstant.MDM_BUSINESS_FORMAT,
                TpmSubsidiaryYearBudgetConstant.TPM_SUB_COM_BUDGET_TYPE,
                TpmSubsidiaryYearBudgetConstant.TPM_GROUP_CODE));
        for (TpmSubsidiaryYearBudgetDetailExportVo vo : data) {
            vo.setBusinessFormatCode(this.findDictValue(mapDict, DictConstant.MDM_BUSINESS_FORMAT, String.valueOf(vo.getBusinessFormatCode())));
            vo.setBudgetType(this.findDictValue(mapDict, TpmSubsidiaryYearBudgetConstant.TPM_SUB_COM_BUDGET_TYPE, String.valueOf(vo.getBudgetType())));
            vo.setGroupCode(this.findDictValue(mapDict, TpmSubsidiaryYearBudgetConstant.TPM_GROUP_CODE, String.valueOf(vo.getGroupCode())));
        }
    }


    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private TpmSubsidiaryYearBudgetDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), TpmSubsidiaryYearBudgetDto.class);
    }

    @Override
    public String getBusinessCode() {
        return "sub_com_year_budget_detail_export";
    }

    @Override
    public String getBusinessName() {
        return "分子年度预算明细导出";
    }
}
