package com.biz.crm.tpm.business.subsidiary.year.budget.local.handler;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.constant.TpmSubsidiaryYearBudgetConstant;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetImportDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetMonthDetailDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetDetailTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName TpmSubsidiaryYearBudgetImportHandler
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Component
@Slf4j
public class TpmSubsidiaryYearBudgetImportHandler implements ImportProcess<TpmSubsidiaryYearBudgetImportDto> {

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetService subsidiaryYearBudgetService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Override
    public Integer getBatchCount() {
        return 2000;
    }

    /**
     * 是否开启先校验后导入的模式 默认false: false执行旧逻辑 true执行新逻辑(先校验再保存) <br/>
     * 新逻辑需同时实现接口 tryVerify tryConfirm（默认方法调用execute）
     *
     * @return
     */
    @Override
    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    @Override
    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, TpmSubsidiaryYearBudgetImportDto> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();
        Map<String, String> budgetTypeMap = dictToolkitService.findConvertMapByDictTypeCode(TpmSubsidiaryYearBudgetConstant.TPM_SUB_COM_BUDGET_TYPE);
        for (Map.Entry<Integer, TpmSubsidiaryYearBudgetImportDto> entry : data.entrySet()) {
            int rowNum = entry.getKey();
            TpmSubsidiaryYearBudgetImportDto dto = entry.getValue();
            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBudgetTypeDesc()), "预算类型必填!");
            this.validateIsTrue(budgetTypeMap.containsKey(dto.getBudgetTypeDesc()), "预算类型不合法!");
            if (StringUtil.isNotEmpty(dto.getBudgetTypeDesc())
                    && budgetTypeMap.containsKey(dto.getBudgetTypeDesc())) {
                String budgetType = budgetTypeMap.get(dto.getBudgetTypeDesc());
                TpmSubsidiaryYearBudgetTypeEnum budgetTypeEnum = TpmSubsidiaryYearBudgetTypeEnum.codeToEnum(budgetType);
                this.validateIsTrue(Objects.nonNull(budgetTypeEnum), "当前预算类型不支持!");
                if (Objects.nonNull(budgetTypeEnum)) {
                    dto.setBudgetType(budgetType);
                    switch (budgetTypeEnum) {
                        case SALES_VOLUME:
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber1()), "附件总数1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber2()), "附件总数2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber3()), "附件总数3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber4()), "附件总数4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber5()), "附件总数5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber6()), "附件总数6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber7()), "附件总数7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber8()), "附件总数8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber9()), "附件总数9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber10()), "附件总数10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber11()), "附件总数11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAttachmentNumber12()), "附件总数12月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount1()), "折前销售额1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount2()), "折前销售额2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount3()), "折前销售额3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount4()), "折前销售额4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount5()), "折前销售额5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount6()), "折前销售额6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount7()), "折前销售额7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount8()), "折前销售额8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount9()), "折前销售额9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount10()), "折前销售额10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount11()), "折前销售额11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBeforeDiscountAmount12()), "折前销售额12月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount1()), "折后销售额1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount2()), "折后销售额2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount3()), "折后销售额3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount4()), "折后销售额4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount5()), "折后销售额5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount6()), "折后销售额6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount7()), "折后销售额7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount8()), "折后销售额8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount9()), "折后销售额9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount10()), "折后销售额10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount11()), "折后销售额11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAfterDiscountAmount12()), "折后销售额12月必填!");

                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber1()), "附件总数1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber2()), "附件总数2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber3()), "附件总数3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber4()), "附件总数4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber5()), "附件总数5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber6()), "附件总数6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber7()), "附件总数7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber8()), "附件总数8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber9()), "附件总数9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber10()), "附件总数10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber11()), "附件总数11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAttachmentNumber12()), "附件总数12月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount1()), "折前销售额1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount2()), "折前销售额2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount3()), "折前销售额3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount4()), "折前销售额4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount5()), "折前销售额5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount6()), "折前销售额6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount7()), "折前销售额7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount8()), "折前销售额8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount9()), "折前销售额9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount10()), "折前销售额10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount11()), "折前销售额11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getBeforeDiscountAmount12()), "折前销售额12月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount1()), "折后销售额1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount2()), "折后销售额2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount3()), "折后销售额3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount4()), "折后销售额4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount5()), "折后销售额5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount6()), "折后销售额6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount7()), "折后销售额7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount8()), "折后销售额8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount9()), "折后销售额9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount10()), "折后销售额10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount11()), "折后销售额11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAfterDiscountAmount12()), "折后销售额12月不合法!");

                            break;
                        case COST:
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount1()), "点外费用1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount2()), "点外费用2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount3()), "点外费用3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount4()), "点外费用4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount5()), "点外费用5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount6()), "点外费用6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount7()), "点外费用7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount8()), "点外费用8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount9()), "点外费用9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount10()), "点外费用10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount11()), "点外费用11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getExternalAmount12()), "点外费用12月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount1()), "点内费用1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount2()), "点内费用2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount3()), "点内费用3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount4()), "点内费用4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount5()), "点内费用5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount6()), "点内费用6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount7()), "点内费用7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount8()), "点内费用8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount9()), "点内费用9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount10()), "点内费用10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount11()), "点内费用11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getInternalAmount12()), "点内费用12月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount1()), "自投费用1月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount2()), "自投费用2月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount3()), "自投费用3月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount4()), "自投费用4月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount5()), "自投费用5月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount6()), "自投费用6月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount7()), "自投费用7月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount8()), "自投费用8月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount9()), "自投费用9月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount10()), "自投费用10月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount11()), "自投费用11月必填!");
                            this.validateIsTrue(StringUtil.isNotEmpty(dto.getAutomaticAmount12()), "自投费用12月必填!");

                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount1()), "点外费用1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount2()), "点外费用2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount3()), "点外费用3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount4()), "点外费用4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount5()), "点外费用5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount6()), "点外费用6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount7()), "点外费用7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount8()), "点外费用8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount9()), "点外费用9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount10()), "点外费用10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount11()), "点外费用11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getExternalAmount12()), "点外费用12月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount1()), "点内费用1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount2()), "点内费用2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount3()), "点内费用3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount4()), "点内费用4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount5()), "点内费用5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount6()), "点内费用6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount7()), "点内费用7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount8()), "点内费用8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount9()), "点内费用9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount10()), "点内费用10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount11()), "点内费用11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getInternalAmount12()), "点内费用12月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount1()), "自投费用1月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount2()), "自投费用2月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount3()), "自投费用3月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount4()), "自投费用4月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount5()), "自投费用5月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount6()), "自投费用6月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount7()), "自投费用7月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount8()), "自投费用8月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount9()), "自投费用9月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount10()), "自投费用10月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount11()), "自投费用11月不合法!");
                            this.validateIsTrue(valStringToBigDecimal(dto.getAutomaticAmount12()), "自投费用12月不合法!");
                            break;
                        default:
                            this.validateIsTrue(false, "当前预算类型不支持!");
                            break;
                    }

                }
            }
            this.validateIsTrue(StringUtil.isNotEmpty(dto.getBusinessFormatCode()), "业态必填!");
            this.validateIsTrue(StringUtil.isNotEmpty(dto.getYearLy()), "年份必填!");
            this.validateIsTrue(StringUtil.isNotEmpty(dto.getCustomerChannelCode()), "客户渠道编码必填!");
//            this.validateIsTrue(StringUtil.isNotEmpty(dto.getGroupCode()), "分组必填!");
            this.validateIsTrue(StringUtil.isNotEmpty(dto.getSalesInstitutionCode()), "销售公司编码必填!");
//            this.validateIsTrue(StringUtil.isNotEmpty(dto.getActivityTypeCode()), "活动类型编码必填!");

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            }
        }
        return errMap;
    }

    /**
     * 验证 string 转 BigDecimal
     *
     * @param amount
     * @return
     */
    private boolean valStringToBigDecimal(String amount) {
        if (StringUtil.isEmpty(amount)) {
            return true;
        }
        try {
            new BigDecimal(amount);
            return true;
        } catch (Exception e) {
            log.error("", e);
        }
        return false;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmSubsidiaryYearBudgetImportDto> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();
        List<TpmSubsidiaryYearBudgetDto> mainResult = new ArrayList<>();
        List<TpmSubsidiaryYearBudgetMonthDetailDto> detailResult = new ArrayList<>();
        log.error("分子年度预算导入-进入执行方法");
        //客户信息
        Set<String> customerCodeSet = Sets.newHashSet();
        //销售组织信息
        Map<String, SalesOrgVo> salesOrgMap = null;
        Set<String> salesOrgCodeSet = Sets.newHashSet();
        //组织信息
        Set<String> orgCodeSet = Sets.newHashSet();
        List<TpmSubsidiaryYearBudgetImportDto> importDtoList = new ArrayList<>(data.values());


        Map<String, String> budgetTypeMap = dictToolkitService.findConvertMapByDictTypeCode(TpmSubsidiaryYearBudgetConstant.TPM_SUB_COM_BUDGET_TYPE);
        for (TpmSubsidiaryYearBudgetImportDto importDto : importDtoList) {
            if (StringUtils.isNotEmpty(importDto.getBudgetTypeDesc())){
                importDto.setBudgetType(budgetTypeMap.get(importDto.getBudgetTypeDesc()));
            }
        }


        importDtoList.forEach(o -> {
            String keyPrefix = o.getCustomerChannelCode() + BusinessFormatEnum.descToEnum(o.getBusinessFormatCode()).getCode();
            if (org.springframework.util.StringUtils.hasText(o.getSalesInstitutionCode())) {
                String insCode = keyPrefix + o.getSalesInstitutionCode();
                salesOrgCodeSet.add(insCode);
                if (org.springframework.util.StringUtils.hasText(o.getSalesOrgCode())) {
                    String groupCode = insCode + o.getSalesOrgCode();
                    salesOrgCodeSet.add(groupCode);
                    if (org.springframework.util.StringUtils.hasText(o.getSalesGroupCode())) {
                        String salesCode = groupCode + o.getSalesGroupCode();
                        salesOrgCodeSet.add(salesCode);
                    }
                }
            }


            if (org.springframework.util.StringUtils.hasText(o.getOrgCode())) {
                orgCodeSet.add(o.getOrgCode());
            }
            if (org.springframework.util.StringUtils.hasText(o.getDepartmentCode())) {
                orgCodeSet.add(o.getDepartmentCode());
            }
            if (StringUtils.isNotBlank(o.getCustomerCode())) {
                customerCodeSet.add(o.getCustomerCode() + o.getSalesInstitutionCode() + keyPrefix);
            }
        });

        Map<String, CustomerVo> customerMap = null;
        if (CollectionUtils.isNotEmpty(customerCodeSet)) {
            List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (CollectionUtils.isNotEmpty(customerVoList)) {
                customerMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            } else {
                customerMap = Maps.newHashMap();
            }
        }
        if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (CollectionUtils.isNotEmpty(salesOrgVoList)) {
                salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            } else {
                salesOrgMap = Maps.newHashMap();
            }
        }

        Map<String, OrgVo> orgMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgCodeSet)) {
            List<OrgVo> orgVoList = orgVoService.findByOrgCodes(new ArrayList<>(orgCodeSet));
            if (CollectionUtils.isNotEmpty(orgVoList)) {
                orgMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
            }
        }

        //活动分类信息
        Map<String, ActivityTypeVo> activityTypeMap = null;
        Set<String> activityTypeCodeSet = importDtoList.stream().map(TpmSubsidiaryYearBudgetImportDto::getActivityTypeCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(activityTypeCodeSet)) {
            List<ActivityTypeVo> activityTypeVoList = activityTypeService.findByCodes(new ArrayList<>(activityTypeCodeSet));
            if (CollectionUtils.isNotEmpty(activityTypeVoList)) {
                activityTypeMap = activityTypeVoList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity()));
            } else {
                activityTypeMap = Maps.newHashMap();
            }
        }
        //活动形式信息
        Map<String, ActivityFormVo> activityFormMap = null;
        Set<String> activityFormCodeSet = importDtoList.stream().map(TpmSubsidiaryYearBudgetImportDto::getActivityFormCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(activityFormCodeSet)) {
            List<ActivityFormVo> activityFormVoList = activityFormService.findActivityFormByCode(activityFormCodeSet);
            if (CollectionUtils.isNotEmpty(activityFormVoList)) {
                activityFormMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
            } else {
                activityFormMap = Maps.newHashMap();
            }
        }
        Map<String, BudgetItemVo> budgetItemMap = null;
        Set<String> budgetItemCodeSet = importDtoList.stream().map(TpmSubsidiaryYearBudgetImportDto::getBudgetItemCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(budgetItemCodeSet)) {
            List<BudgetItemVo> budgetItemVoList = budgetItemService.listByCodes(new ArrayList<>(budgetItemCodeSet));
            if (CollectionUtils.isNotEmpty(budgetItemVoList)) {
                budgetItemMap = budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            } else {
                budgetItemMap = Maps.newHashMap();
            }
        }

        //字典集合
        Map<String, String> groupDict = dictToolkitService.findConvertMapByDictTypeCode(TpmSubsidiaryYearBudgetConstant.TPM_GROUP_CODE);
        for (Map.Entry<Integer, TpmSubsidiaryYearBudgetImportDto> entry : data.entrySet()) {
            int rowNum = entry.getKey();
            TpmSubsidiaryYearBudgetImportDto importDto = entry.getValue();
            TpmSubsidiaryYearBudgetDto entity = nebulaToolkitService.copyObjectByWhiteList(importDto, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            String subsidiaryYearBudgetCode = generateCodeService.generateCode(TpmSubsidiaryYearBudgetConstant.TPM_SUBSIDIARY_YEAR_BUDGET_CODE_PREFIX, 1, 6, 2, TimeUnit.DAYS).get(0);
            //设置编码及必要参数
            entity.setYearBudgetCode(subsidiaryYearBudgetCode);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setMd5UniqueKey(entity.generateUniqueKey());
            //字典字段转换
            if (StringUtils.isNotEmpty(importDto.getGroupCode())) {
                entity.setGroupCode(groupDict.get(importDto.getGroupCode()));
            }
            entity.setBusinessFormatCode(BusinessFormatEnum.descToEnum(importDto.getBusinessFormatCode()).getCode());
            entity.setCustomerChannelCode(importDto.getCustomerChannelCode());
            entity.setCustomerChannelName(importDto.getCustomerChannelName());

            //必要字段填充
            if (org.springframework.util.StringUtils.hasText(importDto.getSalesInstitutionCode())) {
                String insCode = entity.getCustomerChannelCode() + entity.getBusinessFormatCode() + importDto.getSalesInstitutionCode();
                SalesOrgVo vo1 = salesOrgMap.get(insCode);
                if (null == vo1) {
                    validateIsTrue(false, "销售机构编码无关联销售组织信息");
                    entity.setSalesInstitutionErpCode("");
                } else {
                    entity.setSalesInstitutionCode(vo1.getSalesOrgCode());
                    entity.setSalesInstitutionErpCode(vo1.getErpCode());
                    entity.setSalesInstitutionName(vo1.getSalesOrgName());
                }
                if (org.springframework.util.StringUtils.hasText(importDto.getSalesOrgCode())) {
                    String groupCode = insCode + importDto.getSalesOrgCode();
                    SalesOrgVo vo2 = salesOrgMap.get(groupCode);
                    if (null == vo2) {
                        validateIsTrue(false, "销售部门编码无关联销售组织信息");
                    } else {
                        entity.setSalesOrgCode(vo2.getSalesOrgCode());
                        entity.setSalesOrgErpCode(vo2.getErpCode());
                        entity.setSalesOrgName(vo2.getSalesOrgName());
                    }
                    if (org.springframework.util.StringUtils.hasText(importDto.getSalesGroupCode())) {
                        String salesCode = groupCode + importDto.getSalesGroupCode();
                        SalesOrgVo vo3 = salesOrgMap.get(salesCode);
                        if (null == vo3) {
                            validateIsTrue(false, "销售组编码无关联销售组织信息");
                        } else {
                            entity.setSalesGroupCode(vo3.getSalesOrgCode());
                            entity.setSalesGroupErpCode(vo3.getErpCode());
                            entity.setSalesGroupName(vo3.getSalesOrgName());
                        }
                    }
                }
            }
            if (org.springframework.util.StringUtils.hasText(importDto.getCustomerCode())) {
                String cusCode = importDto.getCustomerCode() + entity.getSalesInstitutionErpCode() + entity.getCustomerChannelCode() + entity.getBusinessFormatCode();
                CustomerVo customerVo = customerMap.get(cusCode);
                if (customerVo != null) {
                    entity.setCustomerCode(customerVo.getCustomerCode());
                    entity.setCustomerName(customerVo.getCustomerName());
                    entity.setCustomerErpCode(customerVo.getErpCode());
                    entity.setCustomerChannelCode(customerVo.getCustomerChannelCode());
                    entity.setCustomerChannelName(customerVo.getCustomerChannelName());
                } else {
                    validateIsTrue(false, "客户编码无关联客户信息");
                }
            }

            if (StringUtils.isNotEmpty(importDto.getActivityTypeCode())){
            if (activityTypeMap != null) {
                ActivityTypeVo activityType = activityTypeMap.get(importDto.getActivityTypeCode());
                if (activityType != null) {
                    entity.setActivityTypeName(activityType.getActivityTypeName());
                } else {
                    validateIsTrue(false, "活动分类编码无关联活动分类信息");
                }
            } else {
                validateIsTrue(false, "活动分类编码无关联活动分类信息");
            }
            }
            if (StringUtils.isNotEmpty(importDto.getActivityFormCode())) {
                ActivityFormVo activityForm = activityFormMap.get(importDto.getActivityFormCode());
                if (activityForm != null) {
                    entity.setActivityFormName(activityForm.getActivityFormName());
                } else {
                    validateIsTrue(false, "活动形式编码无关联活动形式信息");
                }
            }
            if (StringUtils.isNotBlank(importDto.getBudgetItemCode())) {
                if (budgetItemMap != null) {
                    BudgetItemVo budgetItemVo = budgetItemMap.get(importDto.getBudgetItemCode());
                    if (budgetItemVo != null) {
                        entity.setBudgetItemName(budgetItemVo.getBudgetItemName());
                        entity.setBudgetItemLevelCode(budgetItemVo.getBudgetItemLevelCode());
                    } else {
                        validateIsTrue(false, "预算项目编码无关联预算项目信息");
                    }
                } else {
                    validateIsTrue(false, "预算项目编码无关联预算项目信息");
                }
            }

            if (StringUtils.isNotBlank(importDto.getOrgCode())) {
                OrgVo orgVo = orgMap.get(importDto.getOrgCode());
                if (null != orgVo) {
                    entity.setOrgCode(orgVo.getOrgCode());
                    entity.setOrgName(orgVo.getOrgName());
                    if (StringUtils.isNotBlank(importDto.getDepartmentCode())) {
                        OrgVo orgVo2 = orgMap.get(importDto.getDepartmentCode());
                        if (null != orgVo2) {
                            entity.setDepartmentCode(orgVo2.getOrgCode());
                            entity.setDepartmentName(orgVo2.getOrgName());
                            if (StringUtils.isBlank(orgVo2.getParentCode()) || !orgVo2.getParentCode().equals(orgVo.getOrgCode())) {
                                validateIsTrue(false, "部门编码不是组织编码下级");
                            }
                        } else {
                            validateIsTrue(false, "部门编码无关联部门信息");
                        }
                    }
                } else {
                    validateIsTrue(false, "组织编码无关联组织信息");
                }
            }

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            } else {
                mainResult.add(entity);
                detailResult.addAll(generateDetailListForImport(importDto, subsidiaryYearBudgetCode));
            }
        }
        if (errMap.isEmpty()) {
            subsidiaryYearBudgetService.saveImport(mainResult, detailResult);
        }
        return errMap;
    }

    private List<TpmSubsidiaryYearBudgetMonthDetailDto> generateDetailListForImport(TpmSubsidiaryYearBudgetImportDto importDto, String subsidiaryYearBudgetCode) {
        try {
            List<TpmSubsidiaryYearBudgetMonthDetailDto> detailList = new ArrayList<>();
            for (int i = 1; i < 13; i++) {
                String budgetType = importDto.getBudgetType();
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(importDto);
                if (TpmSubsidiaryYearBudgetTypeEnum.SALES_VOLUME.getCode().equals(budgetType)) {
                    TpmSubsidiaryYearBudgetMonthDetailDto beforeDiscountDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    beforeDiscountDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    beforeDiscountDetail.setBudgetDetailMonth(String.valueOf(i));
                    beforeDiscountDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode());
                    beforeDiscountDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("beforeDiscountAmount" + i)));
                    beforeDiscountDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    beforeDiscountDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(beforeDiscountDetail);

                    TpmSubsidiaryYearBudgetMonthDetailDto afterDiscountDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    afterDiscountDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    afterDiscountDetail.setBudgetDetailMonth(String.valueOf(i));
                    afterDiscountDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode());
                    afterDiscountDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("afterDiscountAmount" + i)));
                    afterDiscountDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    afterDiscountDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(afterDiscountDetail);

                    TpmSubsidiaryYearBudgetMonthDetailDto attachmentNumberDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    attachmentNumberDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    attachmentNumberDetail.setBudgetDetailMonth(String.valueOf(i));
                    attachmentNumberDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode());
                    attachmentNumberDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("attachmentNumber" + i)));
                    attachmentNumberDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    attachmentNumberDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(attachmentNumberDetail);

                } else if (TpmSubsidiaryYearBudgetTypeEnum.COST.getCode().equals(budgetType)) {

                    TpmSubsidiaryYearBudgetMonthDetailDto internalDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    internalDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    internalDetail.setBudgetDetailMonth(String.valueOf(i));
                    internalDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode());
                    internalDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("internalAmount" + i)));
                    internalDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    internalDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(internalDetail);

                    TpmSubsidiaryYearBudgetMonthDetailDto externalDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    externalDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    externalDetail.setBudgetDetailMonth(String.valueOf(i));
                    externalDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode());
                    externalDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("externalAmount" + i)));
                    externalDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    externalDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(externalDetail);

                    TpmSubsidiaryYearBudgetMonthDetailDto automaticDetail = new TpmSubsidiaryYearBudgetMonthDetailDto();
                    automaticDetail.setYearBudgetCode(subsidiaryYearBudgetCode);
                    automaticDetail.setBudgetDetailMonth(String.valueOf(i));
                    automaticDetail.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode());
                    automaticDetail.setBudgetDetailAmount(new BigDecimal(jsonObject.getString("automaticAmount" + i)));
                    automaticDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    automaticDetail.setTenantCode(TenantUtils.getTenantCode());
                    detailList.add(automaticDetail);
                }

            }
            return detailList;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }

    }

    @Override
    public Class<TpmSubsidiaryYearBudgetImportDto> findCrmExcelVoClass() {
        return TpmSubsidiaryYearBudgetImportDto.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SUBSIDIARY_YEAR_BUDGET_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "分子年度预算导入";
    }
}
