package com.biz.crm.tpm.business.subsidiary.year.budget.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @ClassName TpmSubsidiaryYearBudgetDataViewRegister
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Component
public class TpmSubsidiaryYearBudgetDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_subsidiary_year_budget_data_view";
    }

    @Override
    public String desc() {
        return "TPM-分子年度预算数据视图";
    }

    @Override
    public String buildSql() {
        return "select t.*, " +
                "t2.total_budget_amount,  " +
                "t2.before_discount_amount,  " +
                "t2.after_discount_amount,  " +
                "t2.internal_amount,  " +
                "t2.external_amount,  " +
                "t2.automatic_amount  " +
                "from tpm_subsidiary_year_budget t  " +
                "left join (select year_budget_code,  " +
                "sum(case when budget_detail_type in ('3','4','5') then budget_detail_amount else 0 end) total_budget_amount, " +
                "sum(case when budget_detail_type = '1' then budget_detail_amount else 0 end) before_discount_amount, " +
                "sum(case when budget_detail_type = '2' then budget_detail_amount else 0 end) after_discount_amount, " +
                "sum(case when budget_detail_type = '3' then budget_detail_amount else 0 end) internal_amount, " +
                "sum(case when budget_detail_type = '4' then budget_detail_amount else 0 end) external_amount, " +
                "sum(case when budget_detail_type = '5' then budget_detail_amount else 0 end) automatic_amount " +
                "from tpm_subsidiary_year_budget_month_detail " +
                "where del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() +  "' and tenant_code = :tenantCode " +
                "group by year_budget_code " +
                ") t2 on t.year_budget_code = t2.year_budget_code " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
