package com.biz.crm.tpm.business.subsidiary.year.budget.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.entity.TpmSubsidiaryYearBudgetMonthDetailEntity;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.mapper.TpmSubsidiaryYearBudgetMonthDetailMapper;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetMonthDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * @ClassName TpmSubsidiaryYearBudgetMonthDetailRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Component
public class TpmSubsidiaryYearBudgetMonthDetailRepository extends ServiceImpl<TpmSubsidiaryYearBudgetMonthDetailMapper, TpmSubsidiaryYearBudgetMonthDetailEntity> {
    public List<TpmSubsidiaryYearBudgetMonthDetailEntity> findByYearBudgetCode(String yearBudgetCode) {
        return this.lambdaQuery()
                .eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getYearBudgetCode, yearBudgetCode)
                .eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void deleteByYearBudgetCode(String yearBudgetCode) {
        this.lambdaUpdate().eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getYearBudgetCode, yearBudgetCode)
                .set(TpmSubsidiaryYearBudgetMonthDetailEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
        return;
    }

    public void deleteByYearBudgetIdList(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.baseMapper.deleteByYearBudgetIdList(ids);
    }

    public List<TpmSubsidiaryYearBudgetMonthDetailVo> findByConditionsForSubAuto(TpmSubsidiaryYearBudgetDto selectDto) {
        return this.baseMapper.findByConditionsForSubAuto(selectDto);
    }

    public List<TpmSubsidiaryYearBudgetMonthDetailEntity> getListByYearBudgetCodeList(List<String> yearBudgetCodeList) {
        if (CollectionUtils.isEmpty(yearBudgetCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(TpmSubsidiaryYearBudgetMonthDetailEntity::getYearBudgetCode, yearBudgetCodeList)
                .eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmSubsidiaryYearBudgetMonthDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }
}
