package com.biz.crm.tpm.business.subsidiary.year.budget.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.entity.TpmSubsidiaryYearBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.mapper.TpmSubsidiaryYearBudgetMapper;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetMonthDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * @ClassName TpmSubsidiaryYearBudgetRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Component
public class TpmSubsidiaryYearBudgetRepository extends ServiceImpl<TpmSubsidiaryYearBudgetMapper, TpmSubsidiaryYearBudgetEntity> {
    public void deleteByIdList(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.baseMapper.deleteByIdList(ids);
    }

    public List<TpmSubsidiaryYearBudgetEntity> getByIdList(List<String> ids) {
        return this.baseMapper.selectBatchIds(ids);
    }

    public Page<TpmSubsidiaryYearBudgetMonthDetailVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<TpmSubsidiaryYearBudgetMonthDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if(CollectionUtils.isEmpty(yearMonthList)){
            return page;
        }
        return this.baseMapper.findPageItemForSonCompanyBudgetWarn(page,yearMonthList,orgCode,saleCompanyCode,channelCode,saleGroupCode,customerCode,budgetItemCode);
    }

    public Page<TpmSubsidiaryYearBudgetDetailExportVo> findDetailByConditions(Pageable pageable, TpmSubsidiaryYearBudgetDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new TpmSubsidiaryYearBudgetDto());
        if (StringUtil.isEmpty(dto.getTenantCode())){
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<TpmSubsidiaryYearBudgetMonthDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findDetailByConditions(page,dto);
    }
}
