package com.biz.crm.tpm.business.subsidiary.year.budget.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.entity.TpmSubsidiaryYearBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.entity.TpmSubsidiaryYearBudgetMonthDetailEntity;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.repository.TpmSubsidiaryYearBudgetMonthDetailRepository;
import com.biz.crm.tpm.business.subsidiary.year.budget.local.repository.TpmSubsidiaryYearBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.constant.TpmSubsidiaryYearBudgetConstant;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetLogDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetMonthDetailDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetDetailTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.event.TpmSubsidiaryYearBudgetLogEventListener;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetMonthDetailVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @ClassName TpmSubsidiaryYearBudgetServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/16
 */
@Slf4j
@Service
public class TpmSubsidiaryYearBudgetServiceImpl implements TpmSubsidiaryYearBudgetService {

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetRepository tpmSubsidiaryYearBudgetRepository;

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetMonthDetailRepository tpmSubsidiaryYearBudgetMonthDetailRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private TpmSubsidiaryYearBudgetLogEventListener tpmSubsidiaryYearBudgetLogEventListener;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveImport(List<TpmSubsidiaryYearBudgetDto> main, List<TpmSubsidiaryYearBudgetMonthDetailDto> detail) {
        List<TpmSubsidiaryYearBudgetEntity> mainResult = (List<TpmSubsidiaryYearBudgetEntity>) nebulaToolkitService.copyCollectionByWhiteList(main, TpmSubsidiaryYearBudgetDto.class, TpmSubsidiaryYearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
        Map<String, List<TpmSubsidiaryYearBudgetMonthDetailDto>> listMap = detail.stream()
                .collect(Collectors.groupingBy(TpmSubsidiaryYearBudgetMonthDetailDto::getYearBudgetCode));
        TpmSubsidiaryYearBudgetDto dto = new TpmSubsidiaryYearBudgetDto();
        mainResult.forEach(entity -> {
            List<TpmSubsidiaryYearBudgetMonthDetailDto> detailDtoList = listMap.get(entity.getYearBudgetCode());
            if (CollectionUtil.isEmpty(detailDtoList)) {
                return;
            }
            List<BigDecimal> attachmentNumberList = Lists.newArrayList();
            detailDtoList.stream()
                    .filter(k -> TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode().equals(k.getBudgetDetailType()))
                    .forEach(item -> {
                        if (Objects.nonNull(item.getBudgetDetailAmount())) {
                            attachmentNumberList.add(item.getBudgetDetailAmount());
                        }
                    });
            if (CollectionUtil.isEmpty(attachmentNumberList)) {
                return;
            }
            dto.setAttachmentNumberList(attachmentNumberList);
            setHeadInfo(entity, dto);

        });
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> detailResult = (List<TpmSubsidiaryYearBudgetMonthDetailEntity>) nebulaToolkitService.copyCollectionByWhiteList(detail, TpmSubsidiaryYearBudgetMonthDetailDto.class, TpmSubsidiaryYearBudgetMonthDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        tpmSubsidiaryYearBudgetRepository.saveBatch(mainResult);
        tpmSubsidiaryYearBudgetMonthDetailRepository.saveBatch(detailResult);
        CompletableFuture.runAsync(() -> {
            for (TpmSubsidiaryYearBudgetEntity entity : mainResult) {
                TpmSubsidiaryYearBudgetLogDto logDto = new TpmSubsidiaryYearBudgetLogDto();
                logDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(entity, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
                logDto.setOriginal(new TpmSubsidiaryYearBudgetDto());
                tpmSubsidiaryYearBudgetLogEventListener.onCreate(logDto);
            }
        });
    }

    @Override
    public TpmSubsidiaryYearBudgetVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            throw new UnsupportedOperationException("分子公司年度预算详情查询缺少必要参数");
        }
        TpmSubsidiaryYearBudgetEntity tpmSubsidiaryYearBudget = tpmSubsidiaryYearBudgetRepository.getById(id);
        if (tpmSubsidiaryYearBudget == null || DelFlagStatusEnum.DELETE.getCode().equals(tpmSubsidiaryYearBudget.getDelFlag())) {
            throw new UnsupportedOperationException("未查询到分子公司年度预算详情数据");
        }
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> detailEntityList = tpmSubsidiaryYearBudgetMonthDetailRepository.findByYearBudgetCode(tpmSubsidiaryYearBudget.getYearBudgetCode());
        TpmSubsidiaryYearBudgetVo result = nebulaToolkitService.copyObjectByWhiteList(tpmSubsidiaryYearBudget, TpmSubsidiaryYearBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        result.setBeforeDiscountAmountList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        result.setAfterDiscountAmountList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        result.setInternalAmountList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        result.setExternalAmountList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        result.setAutomaticAmountList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        result.setAttachmentNumberList(Stream.of(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO).collect(Collectors.toList()));
        for (TpmSubsidiaryYearBudgetMonthDetailEntity detailEntity : detailEntityList) {
            if (TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getBeforeDiscountAmountList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            } else if (TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getAfterDiscountAmountList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            } else if (TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getInternalAmountList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            } else if (TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getExternalAmountList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            } else if (TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getAutomaticAmountList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            } else if (TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode().equals(detailEntity.getBudgetDetailType())) {
                result.getAttachmentNumberList().set(Integer.parseInt(detailEntity.getBudgetDetailMonth()) - 1, detailEntity.getBudgetDetailAmount());
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(TpmSubsidiaryYearBudgetDto dto) {
        valBaseInfo(dto);
        TpmSubsidiaryYearBudgetEntity entity = nebulaToolkitService.copyObjectByWhiteList(dto, TpmSubsidiaryYearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);

        entity.setMd5UniqueKey(entity.generateUniqueKey());
        String subsidiaryYearBudgetCode = generateCodeService.generateCode(TpmSubsidiaryYearBudgetConstant.TPM_SUBSIDIARY_YEAR_BUDGET_CODE_PREFIX, 1, 6, 2, TimeUnit.DAYS).get(0);
        entity.setYearBudgetCode(subsidiaryYearBudgetCode);
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> detailEntityList = new ArrayList<>();
        detailEntityList.addAll(generateDetailListForModify(dto.getBeforeDiscountAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode(), subsidiaryYearBudgetCode));
        detailEntityList.addAll(generateDetailListForModify(dto.getAfterDiscountAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode(), subsidiaryYearBudgetCode));
        detailEntityList.addAll(generateDetailListForModify(dto.getInternalAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode(), subsidiaryYearBudgetCode));
        detailEntityList.addAll(generateDetailListForModify(dto.getExternalAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode(), subsidiaryYearBudgetCode));
        detailEntityList.addAll(generateDetailListForModify(dto.getAutomaticAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode(), subsidiaryYearBudgetCode));
        detailEntityList.addAll(generateDetailListForModify(dto.getAttachmentNumberList(), TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode(), subsidiaryYearBudgetCode));
        //设置头部信息
        setHeadInfo(entity, dto);
        tpmSubsidiaryYearBudgetRepository.save(entity);
        tpmSubsidiaryYearBudgetMonthDetailRepository.saveBatch(detailEntityList);
        //保存操作日志
        TpmSubsidiaryYearBudgetLogDto logDto = new TpmSubsidiaryYearBudgetLogDto();
        logDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(entity, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
        logDto.setOriginal(new TpmSubsidiaryYearBudgetDto());
        tpmSubsidiaryYearBudgetLogEventListener.onCreate(logDto);
    }

    /**
     * 设置头部信息
     *
     * @param entity
     * @param dto
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-21 15:57
     */
    private void setHeadInfo(TpmSubsidiaryYearBudgetEntity entity, TpmSubsidiaryYearBudgetDto dto) {
        if (Objects.isNull(entity)
                || Objects.isNull(dto)) {
            return;
        }
        if (CollectionUtil.isNotEmpty(dto.getAttachmentNumberList())) {
            BigDecimal attachmentNumber = dto.getAttachmentNumberList().stream()
                    .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setAttachmentNumber(attachmentNumber);
        }
    }

    private void valBaseInfo(TpmSubsidiaryYearBudgetDto dto) {
        Assert.notNull(dto, "对象不能为空!");
        String budgetType = dto.getBudgetType();
        Assert.hasLength(budgetType, "预算类型不能为空!");
        Assert.hasLength(dto.getBusinessFormatCode(), "业态不能为空!");
        Assert.hasLength(dto.getBusinessUnitCode(), "业务单元不能为空!");
        Assert.hasLength(dto.getGroupCode(), "分组不能为空!");
        Assert.hasLength(dto.getYearLy(), "年份不能为空!");
        Assert.hasLength(dto.getSalesInstitutionCode(), "销售机构编码不能为空!");
        Assert.hasLength(dto.getActivityTypeCode(), "活动类型编码不能为空!");

        TpmSubsidiaryYearBudgetTypeEnum budgetTypeEnum = TpmSubsidiaryYearBudgetTypeEnum.codeToEnum(budgetType);
        Assert.notNull(budgetTypeEnum, "当前预算类型不支持!");
        switch (budgetTypeEnum) {
            case SALES_VOLUME:
                Assert.notEmpty(dto.getAttachmentNumberList(), "附件总数必填!");
                Assert.notEmpty(dto.getBeforeDiscountAmountList(), "折前销售额必填!");
                Assert.notEmpty(dto.getAfterDiscountAmountList(), "折后销售额必填!");
                Assert.isTrue(dto.getAttachmentNumberList().size() == 12, "附件总数必填!");
                Assert.isTrue(dto.getBeforeDiscountAmountList().size() == 12, "折前销售额必填!");
                Assert.isTrue(dto.getAfterDiscountAmountList().size() == 12, "折后销售额必填!");
                dto.setInternalAmountList(Collections.emptyList());
                dto.setExternalAmountList(Collections.emptyList());
                dto.setAutomaticAmountList(Collections.emptyList());
                break;
            case COST:
                Assert.notEmpty(dto.getInternalAmountList(), "点外费用必填!");
                Assert.notEmpty(dto.getExternalAmountList(), "点内费用必填!");
                Assert.notEmpty(dto.getAutomaticAmountList(), "自投费用必填!");
                Assert.isTrue(dto.getInternalAmountList().size() == 12, "点外费用必填!");
                Assert.isTrue(dto.getExternalAmountList().size() == 12, "点内费用必填!");
                Assert.isTrue(dto.getAutomaticAmountList().size() == 12, "自投费用必填!");
                dto.setAttachmentNumberList(Collections.emptyList());
                dto.setBeforeDiscountAmountList(Collections.emptyList());
                dto.setAfterDiscountAmountList(Collections.emptyList());
                break;
            default:
                throw new IllegalArgumentException("当前预算类型不支持!");
        }

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmSubsidiaryYearBudgetDto dto) {
        valBaseInfo(dto);
        Assert.hasLength(dto.getId(),"ID不能为空!");
        TpmSubsidiaryYearBudgetEntity original = tpmSubsidiaryYearBudgetRepository.getById(dto.getId());
        TpmSubsidiaryYearBudgetEntity entity = nebulaToolkitService.copyObjectByWhiteList(dto, TpmSubsidiaryYearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
        entity.setMd5UniqueKey(entity.generateUniqueKey());
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> detailEntityList = new ArrayList<>();
        detailEntityList.addAll(generateDetailListForModify(dto.getBeforeDiscountAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode(), original.getYearBudgetCode()));
        detailEntityList.addAll(generateDetailListForModify(dto.getAfterDiscountAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode(), original.getYearBudgetCode()));
        detailEntityList.addAll(generateDetailListForModify(dto.getInternalAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode(), original.getYearBudgetCode()));
        detailEntityList.addAll(generateDetailListForModify(dto.getExternalAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode(), original.getYearBudgetCode()));
        detailEntityList.addAll(generateDetailListForModify(dto.getAutomaticAmountList(), TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode(), original.getYearBudgetCode()));
        detailEntityList.addAll(generateDetailListForModify(dto.getAttachmentNumberList(), TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode(), original.getYearBudgetCode()));
        tpmSubsidiaryYearBudgetMonthDetailRepository.deleteByYearBudgetCode(original.getYearBudgetCode());
        //设置头部信息
        setHeadInfo(entity, dto);
        tpmSubsidiaryYearBudgetRepository.updateById(entity);
        tpmSubsidiaryYearBudgetMonthDetailRepository.saveBatch(detailEntityList);

        //保存操作日志
        TpmSubsidiaryYearBudgetLogDto logDto = new TpmSubsidiaryYearBudgetLogDto();
        logDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(entity, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
        logDto.setOriginal(nebulaToolkitService.copyObjectByWhiteList(original, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
        tpmSubsidiaryYearBudgetLogEventListener.onUpdate(logDto);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, "请选择数据");
        List<TpmSubsidiaryYearBudgetEntity> entityList = tpmSubsidiaryYearBudgetRepository.getByIdList(ids);
        tpmSubsidiaryYearBudgetMonthDetailRepository.deleteByYearBudgetIdList(ids);
        tpmSubsidiaryYearBudgetRepository.deleteByIdList(ids);
        for (TpmSubsidiaryYearBudgetEntity entity : entityList) {
            TpmSubsidiaryYearBudgetLogDto logDto = new TpmSubsidiaryYearBudgetLogDto();
            TpmSubsidiaryYearBudgetDto original = nebulaToolkitService.copyObjectByWhiteList(entity, TpmSubsidiaryYearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            TpmSubsidiaryYearBudgetDto newest = JSON.parseObject(JSON.toJSONString(original), TpmSubsidiaryYearBudgetDto.class);
            newest.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logDto.setOriginal(original);
            logDto.setNewest(newest);
            tpmSubsidiaryYearBudgetLogEventListener.onDelete(logDto);
        }
    }

    private List<TpmSubsidiaryYearBudgetMonthDetailEntity> generateDetailListForModify(List<BigDecimal> detailList, String detailTypeCode, String subsidiaryYearBudgetCode) {
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> result = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(detailList)) {
            String tenantCode = TenantUtils.getTenantCode();
            for (int i = 0; i < 12; i++) {
                TpmSubsidiaryYearBudgetMonthDetailEntity detail = new TpmSubsidiaryYearBudgetMonthDetailEntity();
                detail.setYearBudgetCode(subsidiaryYearBudgetCode);
                detail.setBudgetDetailType(detailTypeCode);
                detail.setBudgetDetailMonth(String.valueOf(i + 1));
                detail.setBudgetDetailAmount(detailList.get(i));
                detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                detail.setTenantCode(tenantCode);
                result.add(detail);
            }
        }
        return result;
    }

    @Override
    public List<TpmSubsidiaryYearBudgetMonthDetailVo> findByConditionsForSubAuto(TpmSubsidiaryYearBudgetDto selectDto) {
        if (Objects.isNull(selectDto)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank(selectDto.getBusinessFormatCode())
                || StringUtils.isBlank(selectDto.getBusinessUnitCode())
                || StringUtils.isBlank(selectDto.getYearLy())
                || StringUtils.isBlank(selectDto.getOrgCode())) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank(selectDto.getTenantCode())) {
            selectDto.setTenantCode(TenantUtils.getTenantCode());
        }
        List<TpmSubsidiaryYearBudgetMonthDetailVo> list = this.tpmSubsidiaryYearBudgetMonthDetailRepository.findByConditionsForSubAuto(selectDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public Page<TpmSubsidiaryYearBudgetMonthDetailVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        if(CollectionUtils.isEmpty(yearMonthList)){
            return new Page<>(0,0);
        }
        return this.tpmSubsidiaryYearBudgetRepository.findPageItemForSonCompanyBudgetWarn(pageable,yearMonthList,orgCode,saleCompanyCode,channelCode,saleGroupCode,customerCode,budgetItemCode);
    }

    /**
     * 分页查询所有明细
     *
     * @param pageable
     * @param dto
     * @return java.lang.String
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-21 23:19
     */
    @Override
    public Page<TpmSubsidiaryYearBudgetDetailExportVo> findDetailByConditions(Pageable pageable, TpmSubsidiaryYearBudgetDto dto) {
        Page<TpmSubsidiaryYearBudgetDetailExportVo> pageResult = this.tpmSubsidiaryYearBudgetRepository.findDetailByConditions(pageable, dto);
        if (CollectionUtil.isEmpty(pageResult.getRecords())) {
            return pageResult;
        }
        List<String> yearBudgetCodeList = pageResult.getRecords().stream().map(TpmSubsidiaryYearBudgetDetailExportVo::getYearBudgetCode)
                .distinct().collect(Collectors.toList());
        List<TpmSubsidiaryYearBudgetMonthDetailEntity> detailEntityList = this.tpmSubsidiaryYearBudgetMonthDetailRepository.getListByYearBudgetCodeList(yearBudgetCodeList);
        if (CollectionUtil.isEmpty(detailEntityList)) {
            return pageResult;
        }
        Map<String, TpmSubsidiaryYearBudgetMonthDetailEntity> detailMap = detailEntityList.stream()
                .collect(Collectors.toMap(v -> v.getYearBudgetCode() + v.getBudgetDetailType() + v.getBudgetDetailMonth(), v -> v, (n, o) -> n));
        pageResult.getRecords().forEach(item -> {
            item.setAttachmentNumber1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAttachmentNumber12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.ATTACHMENT_NUMBER.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());

            item.setBeforeDiscountAmount1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setBeforeDiscountAmount12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());

            item.setAfterDiscountAmount1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAfterDiscountAmount12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());

            item.setInternalAmount1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setInternalAmount12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.INTERNAL.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());

            item.setExternalAmount1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setExternalAmount12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.EXTERNAL.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());

            item.setAutomaticAmount1(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 1,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount2(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 2,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount3(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 3,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount4(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 4,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount5(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 5,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount6(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 6,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount7(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 7,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount8(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 8,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount9(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 9,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount10(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 10,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount11(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 11,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
            item.setAutomaticAmount12(detailMap.getOrDefault(item.getYearBudgetCode() + TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode() + 12,
                    new TpmSubsidiaryYearBudgetMonthDetailEntity()).getBudgetDetailAmount());
        });
        return pageResult;
    }
}
