package com.biz.crm.tpm.business.audit.summary.configure.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import liquibase.pro.packaged.E;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
@RestController
@RequestMapping("/v1/summary/configure")
@Api(tags = "TPM-客户合并计量配置表接口")
@Slf4j
public class TpmCustomerSummaryConfigureController {

    @Autowired(required = false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;

    @ApiOperation(value = "删除")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            tpmCustomerSummaryConfigureService.deleteByIds(ids);
        } catch (Exception e) {
            return Result.error(e.getMessage());
        }
        return Result.ok();
    }

    @ApiOperation(value = "启用")
    @PostMapping("enable")
    public Result<?> enable(@RequestBody ArrayList<String> ids) {
        try {
            tpmCustomerSummaryConfigureService.enable(ids);
        } catch (Exception e) {
            return Result.error(e.getMessage());
        }
        return Result.ok();
    }

    @ApiOperation(value = "禁用")
    @PostMapping("disable")
    public Result<?> disable(@RequestBody ArrayList<String> ids) {
        try {
            tpmCustomerSummaryConfigureService.disable(ids);
        } catch (Exception e) {
            return Result.error(e.getMessage());
        }
        return Result.ok();
    }
}
