package com.biz.crm.tpm.business.audit.summary.configure.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
@Getter
@Setter
@ApiModel(value = "TpmCustomerSummaryConfigureEntity", description = "客户合并计量配置表")
@TableName("tpm_customer_summary_configure")
@Entity(name = "tpm_customer_summary_configure")
@org.hibernate.annotations.Table(appliesTo = "tpm_customer_summary_configure", comment = "客户合并计量配置表")
@Table(name = "tpm_customer_summary_configure", indexes = {
        @Index(name = "index1", columnList = "customer_code"),
        @Index(name = "index2", columnList = "only_key", unique = true)
})
public class TpmCustomerSummaryConfigureEntity extends TenantFlagOpEntity {

    @ApiModelProperty(value = "计费业态", notes = "计费业态")
    @Column(name = "business_format_code", length = 64, columnDefinition = "varchar(64) COMMENT '计费业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "计费销售机构MDG编码", notes = "计费销售机构MDG编码")
    @Column(name = "sales_institution_erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '计费销售机构MDG编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "计费渠道编码", notes = "计费渠道编码")
    @Column(name = "channel_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '计费渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "计费渠道名称", notes = "计费渠道名称")
    @Column(name = "channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '计费渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "计费客户编码", notes = "计费客户编码")
    @Column(name = "customer_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '计费客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "计费MDG客户编码", notes = "计费MDG客户编码")
    @Column(name = "customer_erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '计费MDG客户编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "计费客户名称", notes = "计费客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '计费客户名称'")
    private String customerName;

    @ApiModelProperty(value = "合并取量业态", notes = "合并取量业态")
    @Column(name = "business_format_code_summary", length = 64, columnDefinition = "varchar(64) COMMENT '合并取量业态'")
    private String businessFormatCodeSummary;

    @ApiModelProperty(name = "合并取量销售机构MDG编码", notes = "合并取量销售机构MDG编码")
    @Column(name = "sales_institution_erp_code_summary", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合并取量销售机构MDG编码'")
    private String salesInstitutionErpCodeSummary;

    @ApiModelProperty(name = "合并取量渠道", notes = "合并取量渠道")
    @Column(name = "channel_code_summary", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合并取量渠道'")
    private String channelCodeSummary;

    @ApiModelProperty(name = "合并渠道名称", notes = "合并渠道名称")
    @Column(name = "channel_name_summary", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合并渠道名称'")
    private String channelNameSummary;

    @ApiModelProperty(name = "合并取量客户编码", notes = "合并取量客户编码")
    @Column(name = "customer_code_summary", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合并取量客户编码'")
    private String customerCodeSummary;

    @ApiModelProperty(name = "合并取量MDG客户编码", notes = "合并取量MDG客户编码")
    @Column(name = "customer_erp_code_summary", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合并取量MDG客户编码'")
    private String customerErpCodeSummary;

    @ApiModelProperty(name = "合并取量客户名称", notes = "合并取量客户名称")
    @Column(name = "customer_name_summary", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合并取量客户名称'")
    private String customerNameSummary;

    @ApiModelProperty(name = "唯一码(业态+计费客户编码+合并取量客户编码)", notes = "唯一码(业态+计费客户编码+合并取量客户编码)")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(256) COMMENT '唯一码(业态+计费客户编码+合并取量客户编码)'")
    private String onlyKey;
}
