package com.biz.crm.tpm.business.audit.summary.configure.local.service.impl;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.summary.configure.local.entity.TpmCustomerSummaryConfigureEntity;
import com.biz.crm.tpm.business.audit.summary.configure.local.repository.TpmCustomerSummaryConfigureRepository;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.dto.TpmCustomerSummaryConfigureDto;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.dto.log.TpmCustomerSummaryConfigureLogEventDto;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.event.TpmCustomerSummaryConfigureEventListener;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.vo.TpmCustomerSummaryConfigureVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
@Slf4j
@Service
public class TpmCustomerSummaryConfigureServiceImpl implements TpmCustomerSummaryConfigureService {

    @Autowired(required = false)
    private TpmCustomerSummaryConfigureRepository tpmCustomerSummaryConfigureRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    @Override
    public void deleteByIds(List<String> ids) {
        Validate.notEmpty(ids, "请选择数据！");
        List<TpmCustomerSummaryConfigureEntity> list = this.tpmCustomerSummaryConfigureRepository.lambdaQuery()
                .eq(TpmCustomerSummaryConfigureEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(TpmCustomerSummaryConfigureEntity::getId, ids).list();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<TpmCustomerSummaryConfigureLogEventDto> eventDtoList = new ArrayList<>();
        list.forEach(v -> {
            TpmCustomerSummaryConfigureLogEventDto logEventDto = new TpmCustomerSummaryConfigureLogEventDto();
            TpmCustomerSummaryConfigureDto dto = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureDto.class, null, null);
            logEventDto.setOriginal(dto);
            v.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            v.setOnlyKey(v.getOnlyKey()+ DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN));
            TpmCustomerSummaryConfigureVo vo = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureVo.class, null, null);
            logEventDto.setNewest(vo);
            eventDtoList.add(logEventDto);
        });
        this.tpmCustomerSummaryConfigureRepository.updateBatchById(list);
        SerializableBiConsumer<TpmCustomerSummaryConfigureEventListener, TpmCustomerSummaryConfigureLogEventDto> onDelete =
                TpmCustomerSummaryConfigureEventListener::onDelete;
        eventDtoList.forEach(log -> {
            this.nebulaNetEventClient.publish(log, TpmCustomerSummaryConfigureEventListener.class, onDelete);
        });
    }

    @Transactional
    @Override
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, "请选择数据！");
        List<TpmCustomerSummaryConfigureEntity> list = this.tpmCustomerSummaryConfigureRepository.lambdaQuery()
                .eq(TpmCustomerSummaryConfigureEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmCustomerSummaryConfigureEntity::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
                .in(TpmCustomerSummaryConfigureEntity::getId, ids).list();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<TpmCustomerSummaryConfigureLogEventDto> eventDtoList = new ArrayList<>();
        list.forEach(v -> {
            TpmCustomerSummaryConfigureLogEventDto logEventDto = new TpmCustomerSummaryConfigureLogEventDto();
            TpmCustomerSummaryConfigureDto dto = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureDto.class, null, null);
            logEventDto.setOriginal(dto);
            v.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            TpmCustomerSummaryConfigureVo vo = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureVo.class, null, null);
            logEventDto.setNewest(vo);
            eventDtoList.add(logEventDto);
        });
        this.tpmCustomerSummaryConfigureRepository.updateBatchById(list);
        SerializableBiConsumer<TpmCustomerSummaryConfigureEventListener, TpmCustomerSummaryConfigureLogEventDto> onEnable =
                TpmCustomerSummaryConfigureEventListener::onEnable;
        eventDtoList.forEach(log -> {
            this.nebulaNetEventClient.publish(log, TpmCustomerSummaryConfigureEventListener.class, onEnable);
        });
    }

    @Transactional
    @Override
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, "请选择数据！");
        List<TpmCustomerSummaryConfigureEntity> list = this.tpmCustomerSummaryConfigureRepository.lambdaQuery()
                .eq(TpmCustomerSummaryConfigureEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmCustomerSummaryConfigureEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .in(TpmCustomerSummaryConfigureEntity::getId, ids).list();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<TpmCustomerSummaryConfigureLogEventDto> eventDtoList = new ArrayList<>();
        list.forEach(v -> {
            TpmCustomerSummaryConfigureLogEventDto logEventDto = new TpmCustomerSummaryConfigureLogEventDto();
            TpmCustomerSummaryConfigureDto dto = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureDto.class, null, null);
            logEventDto.setOriginal(dto);
            v.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            TpmCustomerSummaryConfigureVo vo = this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerSummaryConfigureVo.class, null, null);
            logEventDto.setNewest(vo);
            eventDtoList.add(logEventDto);
        });
        this.tpmCustomerSummaryConfigureRepository.updateBatchById(list);
        SerializableBiConsumer<TpmCustomerSummaryConfigureEventListener, TpmCustomerSummaryConfigureLogEventDto> onDisable =
                TpmCustomerSummaryConfigureEventListener::onDisable;
        eventDtoList.forEach(log -> {
            this.nebulaNetEventClient.publish(log, TpmCustomerSummaryConfigureEventListener.class, onDisable);
        });
    }

    /**
     * 通过计费客户编码查合并客户编码(包含积分客户编码)
     *
     * @param customerCodeList
     * @return
     */
    @Override
    public Map<String, Set<String>> configureIncludeMap(List<String> customerCodeList) {
        return this.configureExcludeMap(customerCodeList, true);
    }

    /**
     * 通过计费客户编码查合并客户编码(不包含积分客户编码)
     *
     * @param customerCodeList
     * @param includeFlag
     * @return
     */
    @Override
    public Map<String, Set<String>> configureExcludeMap(List<String> customerCodeList, boolean includeFlag) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Maps.newHashMap();
        }
        List<TpmCustomerSummaryConfigureEntity> list = this.tpmCustomerSummaryConfigureRepository.lambdaQuery()
                .eq(TpmCustomerSummaryConfigureEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmCustomerSummaryConfigureEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .in(TpmCustomerSummaryConfigureEntity::getCustomerCode, customerCodeList)
                .list();
        Map<String, Set<String>> map = list.stream().collect(Collectors.groupingBy(TpmCustomerSummaryConfigureEntity::getCustomerCode, Collectors.mapping(TpmCustomerSummaryConfigureEntity::getCustomerCodeSummary, Collectors.toSet())));
        if (includeFlag) {
            map.forEach((k, v) -> v.add(k));
        }
        return map;
    }
}
