package com.biz.crm.tpm.business.audit.summary.configure.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "客户合并计量配置表")
public class TpmCustomerSummaryConfigureDto extends TenantFlagOpDto {
    @ApiModelProperty(value = "计费业态", notes = "计费业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "计费销售机构MDG编码", notes = "计费销售机构MDG编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "计费渠道", notes = "计费渠道")
    private String channelCode;

    @ApiModelProperty(name = "计费客户编码", notes = "计费客户编码")
    private String customerCode;

    @ApiModelProperty(name = "计费MDG客户编码", notes = "计费MDG客户编码")
    private String customerErpCode;

    @ApiModelProperty(name = "计费客户名称", notes = "计费客户名称")
    private String customerName;

    @ApiModelProperty(value = "合并取量业态", notes = "合并取量业态")
    private String businessFormatCodeSummary;

    @ApiModelProperty(name = "合并取量销售机构MDG编码", notes = "合并取量销售机构MDG编码")
    private String salesInstitutionErpCodeSummary;

    @ApiModelProperty(name = "合并取量渠道", notes = "合并取量渠道")
    private String channelCodeSummary;

    @ApiModelProperty(name = "合并取量客户编码", notes = "合并取量客户编码")
    private String customerCodeSummary;

    @ApiModelProperty(name = "合并取量MDG客户编码", notes = "合并取量MDG客户编码")
    private String customerErpCodeSummary;

    @ApiModelProperty(name = "合并取量客户名称", notes = "合并取量客户名称")
    private String customerNameSummary;

    @ApiModelProperty(name = "唯一码(计费客户编码+合并取量客户编码)", notes = "唯一码(计费客户编码+合并取量客户编码)")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(256) COMMENT '唯一码(计费客户编码+合并取量客户编码)'")
    private String onlyKey;
}
