package com.biz.crm.tpm.business.audit.summary.configure.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class TpmCustomerSummaryConfigureImportDto extends CrmExcelVo {
    @CrmExcelColumn(value = "*计费业态", order = 0)
    private String businessFormatCode;

    @CrmExcelColumn(value = "*计费销售机构MDG编码", order = 1)
    private String salesInstitutionErpCode;

    @CrmExcelColumn(value = "*计费渠道", order = 2)
    private String channelCode;

    @CrmExcelColumn(value = "*计费MDG客户编码", order = 3)
    private String customerErpCode;

    @CrmExcelColumn(value = "计费客户名称", order = 4)
    private String customerName;

    @CrmExcelColumn(value = "*合并取量业态", order = 5)
    private String businessFormatCodeSummary;

    @CrmExcelColumn(value = "*合并取量销售机构MDG编码", order = 6)
    private String salesInstitutionErpCodeSummary;

    @CrmExcelColumn(value = "*合并取量渠道", order = 7)
    private String channelCodeSummary;

    @CrmExcelColumn(value = "*合并取量MDG客户编码", order = 8)
    private String customerErpCodeSummary;

    @CrmExcelColumn(value = "合并取量客户名称", order = 9)
    private String customerNameSummary;
}
