package com.biz.crm.tpm.business.audit.summary.configure.sdk.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
public interface TpmCustomerSummaryConfigureService {

    void deleteByIds(List<String> ids);

    void enable(List<String> ids);

    void disable(List<String> ids);

    /**
     * 通过计费客户编码查合并客户编码(包含积分客户编码)
     *
     * @param customerCodeList
     * @return
     */
    Map<String, Set<String>> configureIncludeMap(List<String> customerCodeList);

    /**
     * 通过计费客户编码查合并客户编码(不包含积分客户编码)
     *
     * @param customerCodeList
     * @param includeFlag
     * @return
     */
    Map<String, Set<String>> configureExcludeMap(List<String> customerCodeList, boolean includeFlag);
}
