package com.biz.crm.tpm.business.vertical.form.table.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.kms.business.invoice.sales.data.sdk.constant.SalesDataConstant;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.TpmPullPosDto;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormService;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Title: SalesDataConsumer
 * @Package: com.biz.crm.kms.business.invoice.sales.data.local.consumer
 * @Description:
 * @Author: cyj
 * @Date: 2022/11/23 - 5:47 PM
 */

@Slf4j
@Component
@RocketMQMessageListener(topic = SalesDataConstant.TPM_PULL_POS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = SalesDataConstant.TPM_PULL_POS_MESSAGE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = SalesDataConstant.TPM_PULL_POS_MESSAGE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class PriceMonitorFormConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private PriceMonitorFormService priceMonitorFormService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("MQ接收成功;内容为:[{}]", message.getMsgBody());
        try {
            TpmPullPosDto dto = JSON.parseObject(message.getMsgBody(), TpmPullPosDto.class);
            log.info("===== 价格监控报表 开始 ======");
            this.priceMonitorFormService.createOrUpdateData(dto);
            log.info("===== 价格监控报表 完成 ======");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}
