package com.biz.crm.tpm.business.vertical.form.table.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.vertical.form.table.local.service.ActivityReturnTransGiftService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 垂直退转赠报表(ActivityReturnTransGiftEntity) 控制层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@RestController
@RequestMapping("/v1/activityReturnTransGift")
@Slf4j
@Api(tags = "垂直退转赠报表")
public class ActivityReturnTransGiftController {

    @Autowired(required = false)
    private ActivityReturnTransGiftService activityReturnTransGiftService;

    /**
     * 新增、更新 数据（审批通过的分子公司活动细案）
     * @param codes
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateItemData")
    public Result<?> createOrUpdateItemData(@RequestParam("codes") @ApiParam(name = "codes", value = "codes") List<String> codes) {
        try {
            activityReturnTransGiftService.createOrUpdateData(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
