package com.biz.crm.tpm.business.vertical.form.table.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 预算使用监控报表(BudgetUseFormController) 控制层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@RestController
@RequestMapping("/v1/budgetUseForm")
@Slf4j
@Api(tags = "预算使用监控报表")
public class BudgetUseFormController {

    @Autowired(required = false)
    private BudgetUseFormService budgetUseFormService;

    /**
     * 新增、更新 数据（预算使用监控报表）
     * @param codes
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateItemData")
    public Result<?> createOrUpdateItemData(@RequestParam("codes") @ApiParam(name = "codes", value = "codes",required = false) List<String> codes) {
        try {
            budgetUseFormService.createOrUpdateData(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
