package com.biz.crm.tpm.business.vertical.form.table.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.TpmPullPosDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.vertical.form.table.local.dto.UpdateQuantityWarnDto;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 价格监控报表(BudgetUseFormController) 控制层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@RestController
@RequestMapping("/v1/priceMonitorForm")
@Slf4j
@Api(tags = "价格监控报表")
public class PriceMonitorFormController {

    @Autowired(required = false)
    private PriceMonitorFormService priceMonitorFormService;


    /**
     * 新增、更新 数据（预算使用监控报表）
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateData")
    public Result<?> createOrUpdateData(@ApiParam("dto")@RequestBody TpmPullPosDto dto) {
        try {
            priceMonitorFormService.createOrUpdateData(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    @ApiOperation(value = "更改预警数量", httpMethod = "POST")
    @PostMapping("/updateQuantityWarn")
    public Result<?> updateQuantityWarn(@RequestBody UpdateQuantityWarnDto dto) {
        try {
            priceMonitorFormService.updateQuantityWarn(dto);
            return Result.ok("设置预警数量成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
