package com.biz.crm.tpm.business.vertical.form.table.local.dataView;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 垂直退转赠报表(AuditFee)数据视图注册器
 *
 * @author wanghaojia
 * @since 2023-07-19 10:31:00
 */
@Component
public class ActivityReturnTransGiftDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_activity_return_trans_gift_data_view";
    }

    @Override
    public String desc() {
        return "TPM-垂直退转赠报表";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                "t.*, " +
                "concat(round(t.month_amount_rate * 100,2),'%') as percent_month_amount_rate, " +
                "b.warning_status as warning_status " +
                "FROM tpm_activity_return_trans_gift t left join tpm_warning_monitoring b on t.id = b.business_code " +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}
