package com.biz.crm.tpm.business.vertical.form.table.local.dataView;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 终端价格监控报表报数据视图注册器
 *
 * @author wanghaojia
 * @since 2023-07-19 10:31:00
 */
@Component
public class PriceMonitorFormDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_price_monitor_form_data_view";
    }

    @Override
    public String desc() {
        return "TPM-终端价格监控报表";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                "t.*, " +
                "if(t.quantity > ifnull(t.quantity_warn,300),'1','3') as quantity_warn_status, " +
                "concat(round(t.promotional_gross * 100,2),'%') as percent_promotional_gross, " +
                "concat(round(t.ac_promotional_gross * 100,2),'%') as percent_ac_promotional_gross, " +
                "concat(round(t.quantity * 100,2),'%') as percent_quantity " +
                "FROM tpm_price_monitor_form t " +
                "WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' " +
                "AND t.tenant_code = :tenantCode ";
    }
}
