package com.biz.crm.tpm.business.vertical.form.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体：垂直退转曾报表
 *
 * @author cyj
 * @since 2023-11-18
 */
@ApiModel(value = "ActivityReturnTransGiftEntity", description = "垂直退转曾报表")
@TableName("tpm_activity_return_trans_gift")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_activity_return_trans_gift")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_return_trans_gift", comment = "垂直退转曾报表")
@Table(name = "tpm_activity_return_trans_gift", indexes = {@Index(name = "tpm_activity_return_trans_gift_inx1", columnList = "system_code", unique = false)})
public class ActivityReturnTransGiftEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "yearMonth", value = "年月", notes = "年月")
    @Column(name = "year_and_month", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearAndMonth;

    @ApiModelProperty(name = "businessFormatCode", value = "业态编码", notes = "业态编码")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("系统/零售商")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '系统'")
    private String systemCode;

    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '系统/零售商名称'")
    private String systemName;

    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String region;

    @ApiModelProperty("区域")
    @Column(name = "region_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty(name = "terminalName", notes = "门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "terminalName", notes = "门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(value = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "monthReturnNum", value = "月累退货数量", notes = "月累退货数量")
    @Column(name = "month_return_num", nullable = true, length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '月累退货数量'")
    private BigDecimal monthReturnNum;

    @ApiModelProperty(name = "monthReturnAmount", value = "月累退货金额", notes = "月累退货金额")
    @Column(name = "month_return_amount", nullable = true, length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '月累退货金额'")
    private BigDecimal monthReturnAmount;

    @ApiModelProperty(name = "quantity", value = "申请数量", notes = "申请数量")
    @Column(name = "quantity", nullable = true, length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '申请数量'")
    private BigDecimal quantity;

    @ApiModelProperty(name = "申请金额", notes = "申请金额")
    @Column(name = "apply_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "月累数量差", notes = "月累数量差")
    @Column(name = "month_differ_num", columnDefinition = "decimal(24,6) COMMENT '月累数量差'")
    private BigDecimal monthDifferNum;

    @ApiModelProperty(name = "月累结案差", notes = "月累结案差")
    @Column(name = "month_differ_amount", columnDefinition = "decimal(24,6) COMMENT '月累结案差'")
    private BigDecimal monthDifferAmount;

    @ApiModelProperty(name = "1~7号结案", notes = "1~7号结案")
    @Column(name = "one_amount", columnDefinition = "decimal(24,6) COMMENT '1~7号结案'")
    private BigDecimal oneAmount;

    @ApiModelProperty(name = "8~14号结案", notes = "8~14号结案")
    @Column(name = "two_amount", columnDefinition = "decimal(24,6) COMMENT '8~14号结案'")
    private BigDecimal twoAmount;

    @ApiModelProperty(name = "15~21号结案", notes = "15~21号结案")
    @Column(name = "three_amount", columnDefinition = "decimal(24,6) COMMENT '15~21号结案'")
    private BigDecimal threeAmount;

    @ApiModelProperty(name = "22~31号结案", notes = "22~31号结案")
    @Column(name = "four_amount", columnDefinition = "decimal(24,6) COMMENT '22~31号结案'")
    private BigDecimal fourAmount;

    @ApiModelProperty(name = "月累结案率", notes = "月累结案率")
    @Column(name = "month_amount_rate", columnDefinition = "decimal(24,6) COMMENT '月累结案率'")
    private BigDecimal monthAmountRate;

    @ApiModelProperty(name = "预警", notes = "预警")
    @Column(name = "early_warn", length = 255, columnDefinition = "varchar(255) COMMENT '预警'")
    private String earlyWarn;

    @ApiModelProperty(name = "唯一建", notes = "唯一建")
    @Column(name = "only_key", length = 255, columnDefinition = "varchar(255) COMMENT '唯一建'")
    private String onlyKey;

}
