package com.biz.crm.tpm.business.vertical.form.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 实体：预算使用监控报表
 *
 * @author cyj
 * @since 2023-11-18
 */
@ApiModel(value = "BudgetUseFormEntity", description = "预算使用监控报表")
@TableName("tpm_budget_use_form")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_budget_use_form")
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_use_form", comment = "预算使用监控报表")
@Table(name = "tpm_budget_use_form",
        indexes = {
                @Index(name = "tpm_budget_use_form_inx1", columnList = "system_code", unique = false),
                @Index(name = "tpm_budget_use_form_inx2", columnList = "budget_item_code", unique = false),
        })
public class BudgetUseFormEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "yearMonth", value = "年月", notes = "年月")
    @Column(name = "year_and_month", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearAndMonth;

    @ApiModelProperty(name = "businessFormatCode", value = "业态编码", notes = "业态编码")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(value = "预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty(value = "预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用归口'")
    private String feeBelongCode;

    @ApiModelProperty("区域")
    @Column(name = "region_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String regionCode;

    @ApiModelProperty("区域")
    @Column(name = "region_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty("系统/零售商")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '系统'")
    private String systemCode;

    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '系统/零售商名称'")
    private String systemName;

    @ApiModelProperty(value = "本月预算金额", notes = "")
    @Column(name = "month_budget_amount", nullable = true, length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '本月预算金额'")
    private BigDecimal monthBudgetAmount;

    @ApiModelProperty(value = "本月预算点数", notes = "")
    @Column(name = "month_budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本月预算点数 '")
    private BigDecimal monthBudgetTotalPoint;

    @ApiModelProperty(value = "本月已使用金额", notes = "")
    @Column(name = "month_used_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本月已使用金额 '")
    private BigDecimal monthUsedAmount;

    @ApiModelProperty(value = "本月费用率", notes = "")
    @Column(name = "month_fee_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本月费用率 '")
    private BigDecimal monthFeeRatio;

    @ApiModelProperty(value = "本月超支额度", notes = "")
    @Column(name = "month_over_expend_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本月超支额度 '")
    private BigDecimal monthOverExpendAmount;

    @ApiModelProperty(value = "本月超支点数", notes = "")
    @Column(name = "month_over_expend_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本月超支点数 '")
    private BigDecimal monthOverExpendPoint;

    @ApiModelProperty(value = "累计预算金额", notes = "")
    @Column(name = "budget_amount", nullable = true, length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '累计预算金额'")
    private BigDecimal budgetAmount;

    @ApiModelProperty(value = "累计预算点数", notes = "")
    @Column(name = "budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计预算点数 '")
    private BigDecimal budgetTotalPoint;

    @ApiModelProperty(value = "累计已使用金额", notes = "")
    @Column(name = "used_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计已使用金额 '")
    private BigDecimal usedAmount;

    @ApiModelProperty(value = "累计费用率", notes = "")
    @Column(name = "fee_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计费用率 '")
    private BigDecimal feeRatio;

    @ApiModelProperty(value = "累计超支额度", notes = "")
    @Column(name = "over_expend_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计超支额度 '")
    private BigDecimal overExpendAmount;

    @ApiModelProperty(value = "累计超支点数", notes = "")
    @Column(name = "over_expend_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计超支点数 '")
    private BigDecimal overExpendPoint;

    @ApiModelProperty(value = "预算使用进度", notes = "")
    @Column(name = "budget_use_progress", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算使用进度 '")
    private BigDecimal budgetUseProgress;

    @ApiModelProperty(value = "销量进度", notes = "")
    @Column(name = "sale_progress", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销量进度 '")
    private BigDecimal saleProgress;

    @ApiModelProperty(value = "vs销量进度", notes = "")
    @Column(name = "vs_sale_progress", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT 'vs销量进度 '")
    private BigDecimal vsSaleProgress;

    @ApiModelProperty(value = "实际销量", notes = "")
    @Column(name = "ac_sale_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销量 '")
    private BigDecimal acSaleAmount;

    @ApiModelProperty(value = "计划销量", notes = "")
    @Column(name = "plan_sale_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计划销量 '")
    private BigDecimal planSaleAmount;

    @ApiModelProperty("唯一键")
    @Column(name = "only_key", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '唯一键'")
    private String onlyKey;

    @ApiModelProperty(name = "预警状态", notes = "预警状态")
    @Column(name = "warn_type", length = 32, columnDefinition = "varchar(32) COMMENT '预警状态'")
    private String warnType;
}
