package com.biz.crm.tpm.business.vertical.form.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 实体：垂直退转曾报表
 *
 * @author cyj
 * @since 2023-11-18
 */
@ApiModel(value = "priceMonitorFormEntity", description = "垂直退转曾报表")
@TableName("tpm_price_monitor_form")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_price_monitor_form")
@org.hibernate.annotations.Table(appliesTo = "tpm_price_monitor_form", comment = "垂直退转曾报表")
@Table(name = "tpm_price_monitor_form", indexes = {
        @Index(name = "tpm_price_monitor_form_inx1", columnList = "system_code", unique = false),
        @Index(name = "tpm_price_monitor_form_inx2", columnList = "sales_date", unique = false),
        @Index(name = "tpm_price_monitor_form_inx3", columnList = "region", unique = false),
        @Index(name = "tpm_price_monitor_form_inx4", columnList = "terminal_code", unique = false),
        @Index(name = "tpm_price_monitor_form_inx5", columnList = "product_code", unique = false),
})
public class PriceMonitorFormEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "salesDate", value = "POS日期", notes = "POS日期")
    @Column(name = "sales_date", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'POS日期'")
    private String salesDate;

    @ApiModelProperty(name = "businessFormatCode", value = "业态编码", notes = "业态编码")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("系统/零售商")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '系统'")
    private String systemCode;

    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '系统/零售商名称'")
    private String systemName;

    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String region;

    @ApiModelProperty("区域")
    @Column(name = "region_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty(name = "terminalName", notes = "门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "terminalName", notes = "门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "kaStoreCode", notes = "KAD编码")
    @Column(name = "ka_store_code", length = 32, columnDefinition = "varchar(32) COMMENT 'KAD编码'")
    private String kaStoreCode;

    @ApiModelProperty(name = "brandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brandCode;

    @ApiModelProperty(name = "brandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String brandName;

    @ApiModelProperty(name = "productItemCode",value = "产品品项编码",notes = "产品品项编码")
    @Column(name = "product_item_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项编码'")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName",value = "产品品项名称",notes = "产品品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "productCategoryCode",value = "产品品类编码",notes = "产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName",value = "产品品类名称",notes = "产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty(value = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "unitCode",value = "单位编码",notes = "单位编码")
    @Column(name = "unit_code", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码'")
    private String unitCode;

    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '数量'")
    private BigDecimal quantity;

    @ApiModelProperty("销售金额")
    @Column(name = "sale_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '销售金额'")
    private BigDecimal saleAmount;

    @ApiModelProperty(name = "activityCode",notes = "活动编码", value= "活动编码")
    @Column(name = "activity_code", nullable = true, length = 32,  columnDefinition = "VARCHAR(32) COMMENT '活动编码 '")
    private String activityCode;

    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32,  columnDefinition = "VARCHAR(32) COMMENT '活动形式编码 '")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 255,  columnDefinition = "VARCHAR(255) COMMENT '活动形式名称 '")
    private String activityFormName;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", nullable = true, length = 255,  columnDefinition = "VARCHAR(255) COMMENT '活动形式说明 '")
    private String activityFormDesc;

    @ApiModelProperty("促销供价")
    @Column(name = "original_supply_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销供价'")
    private BigDecimal originalSupplyPrice;

    @ApiModelProperty("实际供价")
    @Column(name = "ac_supply_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '实际供价'")
    private BigDecimal acSupplyPrice;

    @ApiModelProperty("批复价")
    @Column(name = "approved_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '批复价'")
    private BigDecimal approvedPrice;

    @ApiModelProperty("终端价")
    @Column(name = "terminal_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '终端价'")
    private BigDecimal terminalPrice;

    @ApiModelProperty("红线价1")
    @Column(name = "red_price_one", length = 24, columnDefinition = "decimal(24,6) COMMENT '红线价1'")
    private BigDecimal redPriceOne;

    @ApiModelProperty("红线价2")
    @Column(name = "red_price_two", length = 24, columnDefinition = "decimal(24,6) COMMENT '红线价2'")
    private BigDecimal redPriceTwo;

    @ApiModelProperty(name = "priceWarn",value = "价格预警",notes = "价格预警")
    @Column(name = "price_warn", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '价格预警'")
    private String priceWarn;

    @ApiModelProperty("促销毛利")
    @Column(name = "promotional_gross", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销毛利'")
    private BigDecimal promotionalGross;

    @ApiModelProperty("实际毛利")
    @Column(name = "ac_promotional_gross", length = 24, columnDefinition = "decimal(24,6) COMMENT '实际毛利'")
    private BigDecimal acPromotionalGross;

    @ApiModelProperty(name = "grossWarn",value = "毛利预警",notes = "毛利预警")
    @Column(name = "gross_warn", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '毛利预警'")
    private String grossWarn;

    @ApiModelProperty(name = "onlyKey",value = "唯一键",notes = "唯一键")
    @Column(name = "only_key", nullable = true,length = 255, columnDefinition = "VARCHAR(255) COMMENT '唯一键'")
    private String onlyKey;

    @ApiModelProperty(name = "预警状态", notes = "预警状态")
    @Column(name = "warn_type", length = 32, columnDefinition = "varchar(32) COMMENT '预警状态'")
    private String warnType;

    @ApiModelProperty(name = "预警数量", notes = "预警数量")
    @Column(name = "quantity_warn", length = 32, columnDefinition = "varchar(32) COMMENT '预警数量'")
    private String quantityWarn;

}
