package com.biz.crm.tpm.business.vertical.form.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.ActivityReturnTransGiftEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.mapper.ActivityReturnTransGiftMapper;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.ActivityReturnMonitorWarningQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 垂直退转赠报表(ActivityReturnTransGiftRepository)数据库访问层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@Component
public class ActivityReturnTransGiftRepository extends ServiceImpl<ActivityReturnTransGiftMapper, ActivityReturnTransGiftEntity> {

    public List<ActivityReturnTransGiftEntity> findByOnlyKey(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)){
            return Lists.newArrayList();
        }else {
            return this.lambdaQuery().in(ActivityReturnTransGiftEntity::getOnlyKey,onlyKeys)
                    .select(ActivityReturnTransGiftEntity::getOnlyKey,ActivityReturnTransGiftEntity::getId)
                    .eq(ActivityReturnTransGiftEntity::getTenantCode, TenantUtils.getTenantCode())
                    .eq(ActivityReturnTransGiftEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        }
    }

    public List<Map<String, Object>> findActivityReturnMonitorWarning(ActivityReturnMonitorWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
//        dto.setYearAndMonth(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.findActivityReturnMonitorWarning(dto);
    }
}
