package com.biz.crm.tpm.business.vertical.form.table.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.BudgetUseFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.mapper.BudgetUseFormMapper;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.BudgetUseFormWarningQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 预算使用监控报表(BudgetUseFormRepository)数据库访问层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@Component
public class BudgetUseFormRepository extends ServiceImpl<BudgetUseFormMapper, BudgetUseFormEntity> {

    public List<BudgetUseFormEntity> findByOnlyKey(List<String> onlyKeys) {
        if (CollectionUtil.isEmpty(onlyKeys)) {
            return Lists.newArrayList();
        } else {
            return this.lambdaQuery().in(BudgetUseFormEntity::getOnlyKey, onlyKeys).eq(BudgetUseFormEntity::getTenantCode, TenantUtils.getTenantCode()).eq(BudgetUseFormEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .select(BudgetUseFormEntity::getOnlyKey, BudgetUseFormEntity::getId).list();
        }
    }

    public List<Map<String, Object>> findBudgetUseFormMonitorWarning(BudgetUseFormWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setYearAndMonth(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
        return this.baseMapper.findBudgetUseFormMonitorWarning(dto);
    }
}
